<?php $__env->startSection('title', __('messages.subnets_management')); ?>
<?php $__env->startSection('header', __('messages.subnets_management')); ?>
<?php $__env->startSection('breadcrumb', __('messages.subnets')); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h3 class="card-title"><?php echo e(__('messages.subnets_list')); ?></h3>
            <a href="<?php echo e(route('subnets.create')); ?>" class="btn btn-primary float-right"><?php echo e(__('messages.add_subnet')); ?></a>
        </div>
        <div class="card-body">
            <table class="table table-bordered table-sm">
                <thead>
                <tr>
                    <th>ID</th>
                    <th><?php echo e(__('messages.subnet')); ?></th>
                    <th><?php echo e(__('messages.subnet_type')); ?></th>
                    <th><?php echo e(__('messages.total_ips')); ?></th>
                    <th><?php echo e(__('messages.available_ips')); ?></th>
                    <th><?php echo e(__('messages.actions')); ?></th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $subnets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subnet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($subnet->id); ?></td>
                        <td><?php echo e($subnet->subnet); ?></td>
                        <td><?php echo e($subnet->type); ?></td>
                        <td><?php echo e($subnet->total_ips); ?></td>
                        <td><?php echo e($subnet->countAvailableIps()); ?></td>
                        <td class="text-center">
                            <!-- Ссылка на страницу с IP-адресами -->
                            <a href="<?php echo e(route('subnets.show_ips', $subnet->id)); ?>" class="btn btn-sm btn-primary"><?php echo e(__('View IPs')); ?></a>
                            <!-- Кнопка для редактирования самой подсети -->
                            <a href="<?php echo e(route('subnets.edit', $subnet->id)); ?>" class="btn btn-sm btn-warning"><?php echo e(__('Edit Subnet')); ?></a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\vmmgr.local\resources\views/subnets/index.blade.php ENDPATH**/ ?>