<nav class="main-header navbar navbar-expand navbar-dark navbar-light">
    <!-- Left navbar links -->
    <ul class="navbar-nav">
        <li class="nav-item">
            <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
        </li>
        <li class="nav-item d-none d-sm-inline-block">
            <a href="<?php echo e(url('/')); ?>" class="nav-link"><?php echo e(__('messages.home')); ?></a>
        </li>
    </ul>

    <!-- Right navbar links -->
    <ul class="navbar-nav ml-auto">
        <!-- Language Dropdown Menu -->
        <li class="nav-item dropdown">
            <a class="nav-link" data-toggle="dropdown" href="#">
                <i class="fas fa-language"></i> <?php echo e(strtoupper(App::getLocale())); ?>

            </a>
            <div class="dropdown-menu dropdown-menu-right">
                <a href="<?php echo e(route('switch_language', ['lang' => 'en'])); ?>" class="dropdown-item">
                    English
                </a>
                <a href="<?php echo e(route('switch_language', ['lang' => 'ru'])); ?>" class="dropdown-item">
                    Русский
                </a>
            </div>
        </li>

        <!-- Notifications Dropdown Menu -->
        <li class="nav-item">
            <a class="nav-link" href="<?php echo e(route('jobs.monitoring')); ?>">
                <i class="fas fa-tasks"></i>
                <span class="badge badge-danger navbar-badge" id="queue-notifications-count">0</span>
            </a>
        </li>

        <!-- Settings Icon -->
        <li class="nav-item">
            <a class="nav-link" href="<?php echo e(route('settings.index')); ?>" role="button">
                <i class="fas fa-cogs"></i>
            </a>
        </li>

        <!-- User Profile Dropdown Menu -->
        <li class="nav-item dropdown">
            <a class="nav-link" data-toggle="dropdown" href="#" role="button">
                <i class="fas fa-user-circle"></i>
                <?php echo e(auth()->user()->name ?? auth()->user()->email); ?>

            </a>
            <div class="dropdown-menu dropdown-menu-right">
                <a href="<?php echo e(route('user.settings')); ?>" class="dropdown-item">
                    <i class="fas fa-cog mr-2"></i> <?php echo e(__('messages.settings')); ?>

                </a>
                <div class="dropdown-divider"></div>
                <a href="<?php echo e(route('logout')); ?>" class="dropdown-item"
                   onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                    <i class="fas fa-sign-out-alt mr-2"></i> <?php echo e(__('messages.logout')); ?>

                </a>
                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                    <?php echo csrf_field(); ?>
                </form>
            </div>
        </li>
    </ul>

    <!-- JavaScript for updating queue notifications -->
    <script>
        function updateQueueCount() {
            fetch('<?php echo e(route('queue.count')); ?>')
                .then(response => response.json())
                .then(data => {
                    document.getElementById('queue-notifications-count').innerText = data.count;
                })
                .catch(error => console.error('Error fetching queue data:', error));
        }

        setInterval(updateQueueCount, 5000);
        updateQueueCount();
    </script>
</nav>
<?php /**PATH C:\OSPanel\domains\vmmgr.local\resources\views/layouts/partials/navbar.blade.php ENDPATH**/ ?>