<?php $__env->startSection('title', 'Edit User'); ?>
<?php $__env->startSection('header', 'Edit User'); ?>
<?php $__env->startSection('breadcrumb', 'Edit User'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <form action="<?php echo e(route('users.update', $user->id)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="form-group">
                    <label for="name">Name</label>
                    <input type="text" name="name" class="form-control" value="<?php echo e($user->name); ?>" required>
                </div>
                <div class="form-group">
                    <label for="email">Email</label>
                    <input type="email" name="email" class="form-control" value="<?php echo e($user->email); ?>" required>
                </div>
                <div class="form-group">
                    <label for="role_id">Role</label>
                    <select name="role_id" class="form-control" required>
                        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($role->id); ?>" <?php echo e($user->role_id == $role->id ? 'selected' : ''); ?>>
                                <?php echo e($role->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <!-- Поле для смены пароля -->
                <div class="form-group">
                    <label for="password">New Password</label>
                    <input type="text" name="password" class="form-control" id="password">
                </div>
                <div class="form-group">
                    <label for="password_confirmation">Confirm New Password</label>
                    <input type="password" name="password_confirmation" class="form-control" id="password_confirmation">
                </div>
                <!-- Кнопка для генерации пароля -->
                <div class="form-group">
                    <button type="button" class="btn btn-secondary" onclick="generatePassword()">Generate Password</button>
                </div>
                <button type="submit" class="btn btn-success">Update User</button>
            </form>
        </div>
    </div>

    <!-- Добавление скрипта для генерации пароля -->
    <script>
        function generatePassword() {
            const password = Math.random().toString(36).slice(-8);
            document.getElementById('password').value = password;
            document.getElementById('password_confirmation').value = password;
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\vmmgr.local\resources\views/users/edit.blade.php ENDPATH**/ ?>