<?php $__env->startSection('title', 'Users Management'); ?>
<?php $__env->startSection('header', 'Users'); ?>
<?php $__env->startSection('breadcrumb', 'Users'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Users List</h3>
            <a href="<?php echo e(route('users.create')); ?>" class="btn btn-primary float-right">Add User</a>
        </div>
        <div class="card-body">
            <!-- Форма поиска -->
            <form action="<?php echo e(route('users.index')); ?>" method="GET" class="form-inline mb-3">
                <div class="form-group mr-2">
                    <input type="text" name="search" class="form-control" placeholder="Search by name or email" value="<?php echo e(request('search')); ?>">
                </div>
                <button type="submit" class="btn btn-secondary">Поиск</button>
            </form>

            <table class="table table-bordered table-sm">
                <thead>
                <tr>
                    <th>ID</th>
                    <th>Логин</th>
                    <th>Email</th>
                    <th>Права</th>
                    <th>Статус</th>
                    <th>Действия</th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($user->id); ?></td>
                        <td><?php echo e($user->name); ?></td>
                        <td><?php echo e($user->email); ?></td>
                        <td><?php echo e($user->role->name); ?></td>
                        <td class="text-center">
                            <?php if($user->is_active): ?>
                                <span class="text-success"> Активен <i class="fas fa-check-circle"></i></span>
                            <?php else: ?>
                                <span class="text-danger"> Заблокирован <i class="fas fa-ban"></i></span>
                            <?php endif; ?>
                        </td>
                        <td class="text-center">
                            <a href="<?php echo e(route('users.edit', $user->id)); ?>" class="btn btn-sm btn-warning">Редактировать</a>
                            <form action="<?php echo e(route('users.destroy', $user->id)); ?>" method="POST" style="display:inline;" onsubmit="return confirm('Are you sure you want to delete this user?');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-danger">Удалить</button>
                            </form>
                            <form action="<?php echo e(route('users.block', $user->id)); ?>" method="POST" style="display:inline;">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>
                                <button type="submit" class="btn btn-sm btn-secondary">
                                    <?php echo e($user->is_active ? 'Заблокировать' : 'Разблокировать'); ?>

                                </button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

            <!-- Пагинация -->
            <?php echo e($users->links()); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<script>
    let formToDelete;

    document.querySelectorAll('form[action*="users.destroy"]').forEach(form => {
        form.addEventListener('submit', function(event) {
            event.preventDefault();
            formToDelete = form;
            $('#deleteConfirmationModal').modal('show');
        });
    });

    document.getElementById('confirmDeleteButton').addEventListener('click', function() {
        formToDelete.submit();
    });
</script>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\vmmgr.local\resources\views/users/index.blade.php ENDPATH**/ ?>