<?php $__env->startSection('title', __('messages.edit_subnet')); ?>
<?php $__env->startSection('header', __('messages.edit_subnet')); ?>
<?php $__env->startSection('breadcrumb', __('messages.edit_subnet')); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <form action="<?php echo e(route('subnets.update', $subnet->id)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="form-group">
                    <label for="subnet"><?php echo e(__('messages.subnet')); ?></label>
                    <input type="text" name="subnet" class="form-control" value="<?php echo e($subnet->subnet); ?>" required>
                </div>
                <div class="form-group">
                    <label for="type"><?php echo e(__('messages.subnet_type')); ?></label>
                    <select name="type" class="form-control" required>
                        <option value="ipv4" <?php echo e($subnet->type == 'ipv4' ? 'selected' : ''); ?>>IPv4</option>
                        <option value="ipv6" <?php echo e($subnet->type == 'ipv6' ? 'selected' : ''); ?>>IPv6</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="is_ip_list"><?php echo e(__('messages.is_ip_list')); ?></label>
                    <input type="checkbox" name="is_ip_list" id="is_ip_list" value="1" <?php echo e(old('is_ip_list', $subnet->is_ip_list) ? 'checked' : ''); ?>>
                    <label for="is_ip_list"><?php echo e(__('messages.ip_list_checkbox')); ?></label>
                </div>
                <div class="form-group">
                    <label for="reserved_ips"><?php echo e(__('messages.reserve_ips')); ?></label>
                    <textarea name="reserved_ips" class="form-control" placeholder="<?php echo e(__('messages.enter_reserved_ips')); ?>"><?php echo e($ipAddresses->where('status', 'reserved')->pluck('ip_address')->implode(', ')); ?></textarea>
                </div>
                <button type="submit" class="btn btn-success"><?php echo e(__('messages.update_subnet')); ?></button>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\vmmgr.local\resources\views/subnets/edit.blade.php ENDPATH**/ ?>