<?php $__env->startSection('title', __('messages.template_os_management')); ?>
<?php $__env->startSection('header', __('messages.template_os_management')); ?>
<?php $__env->startSection('breadcrumb', __('messages.template_os_management')); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h3 class="card-title"><?php echo e(__('messages.template_os_list')); ?></h3>
        </div>
        <div class="card-body">
            <h4 class="text-info"><?php echo e(__('messages.installed_os')); ?></h4>
            <table class="table table-hover table-striped table-bordered">
                <thead class="thead-light">
                <tr>
                    <th>#</th>
                    <th><?php echo e(__('messages.name')); ?></th>
                    <th><?php echo e(__('messages.cpu_min')); ?></th>
                    <th><?php echo e(__('messages.ram_min')); ?></th>
                    <th><?php echo e(__('messages.disk_min')); ?></th>
                    <th><?php echo e(__('messages.archive_size')); ?></th>
                    <th><?php echo e(__('messages.local_size')); ?></th>
                    <th><?php echo e(__('messages.status')); ?></th>
                    <th><?php echo e(__('messages.actions')); ?></th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $templateOsList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $os): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($os->id); ?></td>
                        <td><?php echo e($os->name); ?></td>
                        <td><?php echo e($os->cpu_min ?? __('messages.not_available')); ?></td>
                        <td><?php echo e($os->ram_min ?? __('messages.not_available')); ?></td>
                        <td><?php echo e($os->disk_min ?? __('messages.not_available')); ?></td>
                        <td><?php echo e($os->archive_size ?? __('messages.not_available')); ?></td>
                        <td><?php echo e($os->local_size ?? __('messages.not_available')); ?></td>
                        <td>
                            <?php if($os->status === 'available'): ?>
                                <span class="badge badge-success"><?php echo e(__('messages.available')); ?></span>
                            <?php elseif($os->status === 'installed'): ?>
                                <span class="badge badge-primary"><?php echo e(__('messages.installed')); ?></span>
                            <?php else: ?>
                                <span class="badge badge-secondary"><?php echo e(__('messages.unknown')); ?></span>
                            <?php endif; ?>
                        </td>
                        <td class="text-center">
                            <?php if($os->status === 'installed'): ?>
                                <div class="btn-group">
                                    <form action="<?php echo e(route('os.delete', $os->id)); ?>" method="POST" onsubmit="return confirm('<?php echo e(__('messages.delete_confirmation')); ?>');" style="display:inline;">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-danger" title="<?php echo e(__('messages.delete')); ?>">
                                            <i class="fas fa-trash-alt"></i>
                                        </button>
                                    </form>
                                    <form action="<?php echo e(route('os.reinstall', $os->id)); ?>" method="POST" style="display:inline;">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="btn btn-sm btn-warning" title="<?php echo e(__('messages.reinstall')); ?>">
                                            <i class="fas fa-sync-alt"></i>
                                        </button>
                                    </form>
                                </div>
                            <?php elseif($os->status === 'available'): ?>
                                <form action="<?php echo e(route('os.download', $os->id)); ?>" method="POST" style="display:inline;">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="btn btn-sm btn-primary" title="<?php echo e(__('messages.download_and_install')); ?>">
                                        <i class="fas fa-download"></i>
                                    </button>
                                </form>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

            <hr class="my-4">

            <h4 class="text-info"><?php echo e(__('messages.available_os_repositories')); ?></h4>

            <form action="<?php echo e(route('template_os.os.download_multiple')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php $__currentLoopData = $osListFromRepositories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $repoIndex => $repo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="repository-section mb-4">
                        <h5 class="text-primary"><?php echo e(__('messages.repository')); ?> #<?php echo e($repoIndex + 1); ?></h5>

                        <?php if(isset($repo['error'])): ?>
                            <div class="alert alert-danger"><?php echo e($repo['error']); ?></div>
                        <?php else: ?>
                            <table class="table table-hover table-striped table-bordered">
                                <thead class="thead-dark">
                                <tr>
                                    <th>
                                        <input type="checkbox" id="select_all_<?php echo e($repoIndex); ?>" onclick="toggleSelectAll(<?php echo e($repoIndex); ?>)">
                                    </th>
                                    <th><?php echo e(__('messages.name')); ?></th>
                                    <th><?php echo e(__('messages.version')); ?></th>
                                    <th><?php echo e(__('messages.cpu_min')); ?></th>
                                    <th><?php echo e(__('messages.ram_min')); ?></th>
                                    <th><?php echo e(__('messages.disk_min')); ?></th>
                                    <th><?php echo e(__('messages.archive_name')); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $repo['operating_systems']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $os): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><input type="checkbox" name="os_files[]" value="<?php echo e($os['file']); ?>" class="os-checkbox-<?php echo e($repoIndex); ?>"></td>
                                        <td><?php echo e($os['name']); ?></td>
                                        <td><?php echo e(implode(', ', $os['tags'])); ?></td>
                                        <td><?php echo e($os['cpu_min'] ?? __('messages.not_available')); ?></td>
                                        <td><?php echo e($os['ram_min'] ?? __('messages.not_available')); ?></td>
                                        <td><?php echo e($os['disk_min'] ?? __('messages.not_available')); ?></td>
                                        <td><?php echo e($os['file']); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        <?php endif; ?>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <div class="text-right">
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-download"></i> <?php echo e(__('messages.download_selected')); ?>

                    </button>
                </div>
            </form>
        </div>
    </div>

    <script>
        function toggleSelectAll(repoIndex) {
            const checkboxes = document.querySelectorAll(`.os-checkbox-${repoIndex}`);
            const selectAll = document.getElementById(`select_all_${repoIndex}`).checked;
            checkboxes.forEach(checkbox => checkbox.checked = selectAll);
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\vmmgr.local\resources\views/template_os/index.blade.php ENDPATH**/ ?>