<aside class="main-sidebar sidebar-dark-primary elevation-4">
    <!-- Brand Logo -->
    <a href="#" class="brand-link">
        <span class="brand-text font-weight-light">KVM Controller</span>
    </a>


    <div class="sidebar">

        <nav class="mt-2">
            <ul class="nav nav-pills nav-sidebar flex-column nav-compact" data-widget="treeview" role="menu" data-accordion="false">
                <li class="nav-item">
                    <a href="<?php echo e(route('dashboard')); ?>" class="nav-link <?php echo e(Request::is('/') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-tachometer-alt"></i>
                        <p>Главная</p>
                    </a>
                </li>

                <?php if(auth()->user()->hasPermission('manage-roles')): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('roles.index')); ?>" class="nav-link <?php echo e(Request::is('roles*') ? 'active' : ''); ?>">
                            <i class="nav-icon fas fa-user-shield"></i>
                            <p>Роли</p>
                        </a>
                    </li>
                <?php endif; ?>

                <?php if(auth()->user()->hasPermission('manage-users')): ?>
                    <li class="nav-item <?php echo e(Request::is('users*') || Request::is('sessions*') ? 'menu-open' : ''); ?>">
                        <a href="#" class="nav-link <?php echo e(Request::is('users*') || Request::is('sessions*') ? 'active' : ''); ?>">
                            <i class="nav-icon fas fa-users"></i>
                            <p>
                                Пользователи
                                <i class="fas fa-angle-left right"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            <li class="nav-item">
                                <a href="<?php echo e(route('users.index')); ?>" class="nav-link <?php echo e(Request::is('users') ? 'active' : ''); ?>">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Список пользователей</p>
                                </a>
                            </li>

                                <li class="nav-item">
                                    <a href="<?php echo e(route('sessions.index')); ?>" class="nav-link <?php echo e(Request::is('sessions*') ? 'active' : ''); ?>">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>Активные сессии</p>
                                    </a>
                                </li>

                            <li class="nav-item">
                                <a href="#" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Доступы</p>
                                </a>
                            </li>
                        </ul>
                    </li>
                <?php endif; ?>


            <?php if(auth()->user()->hasPermission('manage-host-nodes')): ?>
                    <li class="nav-item <?php echo e(Request::is('host_nodes*') || Request::is('template_os*') ? 'menu-open' : ''); ?>">
                        <a href="#" class="nav-link <?php echo e(Request::is('host_nodes*') || Request::is('template_os*') ? 'active' : ''); ?>">
                            <i class="nav-icon fas fa-server"></i>
                            <p>
                                Узлы кластера
                                <i class="fas fa-angle-left right"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            <li class="nav-item">
                                <a href="<?php echo e(route('host_nodes.index')); ?>" class="nav-link <?php echo e(Request::is('host_nodes') ? 'active' : ''); ?>">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Узлы</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="#" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Статистика</p>
                                </a>
                            </li>

                            <li class="nav-item">
                                <a href="<?php echo e(route('template_os.index')); ?>" class="nav-link <?php echo e(Request::segment(1) === 'template_os' ? 'active' : ''); ?>">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Шаблоны ОС</p>
                                </a>
                            </li>

                        </ul>
                    </li>
                <?php endif; ?>

                <li class="nav-item <?php echo e(Request::is('virtual_machines*') ? 'menu-open' : (Request::is('templates*') ? 'menu-open' : '')); ?>">
                    <a href="#" class="nav-link <?php echo e(Request::is('virtual_machines*') ? 'active' : (Request::is('templates*') ? 'active' : '')); ?>">
                        <i class="nav-icon fas fa-hdd"></i>
                        <p>
                            Виртуальные сервера
                            <i class="fas fa-angle-left right"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?php echo e(route('virtual_machines.index')); ?>" class="nav-link <?php echo e(Request::is('virtual_machines') ? 'active' : ''); ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Список VM</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="#" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Статистика</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('templates.index')); ?>" class="nav-link <?php echo e(Request::is('templates', 'templates/*') ? 'active' : ''); ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Шаблоны VM</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="#" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Диски</p>
                            </a>
                        </li>
                    </ul>
                </li>




                <li class="nav-item">
                    <a href="<?php echo e(route('subnets.index')); ?>" class="nav-link <?php echo e(Request::is('subnets*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-share-alt"></i>
                        <p>IP Адреса</p>
                    </a>
                </li>
            </ul>
        </nav>
    </div>
</aside>
<?php /**PATH C:\OSPanel\domains\vmmgr.local\resources\views/layouts/partials/sidebar.blade.php ENDPATH**/ ?>