<?php $__env->startSection('title', 'Create Virtual Machine Template'); ?>
<?php $__env->startSection('header', 'Create Template'); ?>
<?php $__env->startSection('breadcrumb', 'Create Template'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <form action="<?php echo e(route('templates.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="form-group">
                    <label for="template_name">Template Name</label>
                    <input type="text" name="template_name" class="form-control" required>
                </div>
                <div class="form-group">
                    <label for="cpu">CPU</label>
                    <input type="number" name="cpu" class="form-control" required>
                </div>
                <div class="form-group">
                    <label for="memory">Memory (MB)</label>
                    <input type="number" name="memory" class="form-control" required>
                </div>
                <div class="form-group">
                    <label for="disk_size">Disk Size (GB)</label>
                    <input type="number" name="disk_size" class="form-control" required>
                </div>
                <div class="form-group">
                    <label for="network_bridge">Network Bridge</label>
                    <input type="text" name="network_bridge" class="form-control" value="br0" required>
                </div>
                <div class="form-group">
                    <label for="cpu_emulation">CPU Emulation</label>
                    <select name="cpu_emulation" class="form-control" required>
                        <option value="host">Host</option>
                        <option value="kvm64">KVM64</option>
                        <option value="qemu64">QEMU64</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="network_model">Network Model</label>
                    <select name="network_model" class="form-control" required>
                        <option value="virtio" selected>Virtio</option>
                        <option value="i82551">i82551</option>
                        <option value="i82557b">i82557b</option>
                        <option value="i82559er">i82559er</option>
                        <option value="ne2k_pci">ne2k_pci</option>
                        <option value="pcnet">pcnet</option>
                        <option value="rtl8139">rtl8139</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="storage_pool_id">Storage Pool</label>
                    <select name="storage_pool_id" class="form-control" required>
                        <?php $__currentLoopData = $storagePools; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pool): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($pool->id); ?>"><?php echo e($pool->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <button type="submit" class="btn btn-success">Create Template</button>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\vmmgr.local\resources\views/templates/create.blade.php ENDPATH**/ ?>