<?php $__env->startSection('title', __('messages.manage_ip_list')); ?>
<?php $__env->startSection('header', __('messages.manage_ip_list')); ?>
<?php $__env->startSection('breadcrumb', __('messages.subnet') . ": " . $subnet->subnet); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h3 class="card-title"><?php echo e(__('messages.ip_list')); ?></h3>
        </div>
        <div class="card-body">
            <table class="table table-bordered table-sm">
                <thead>
                <tr>
                    <th><?php echo e(__('messages.ip_address')); ?></th>
                    <th><?php echo e(__('messages.status')); ?></th>
                    <th><?php echo e(__('messages.comment')); ?></th>
                    <th><?php echo e(__('messages.actions')); ?></th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $ipAddresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($ip->ip_address); ?></td>
                        <td><?php echo e($ip->status); ?></td>
                        <td><?php echo e($ip->comment); ?></td>
                        <td class="text-center">
                            <?php if($ip->status === 'available'): ?>
                                <form action="<?php echo e(route('ip.reserve', $ip->id)); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="btn btn-sm btn-warning"><?php echo e(__('Reserve')); ?></button>
                                </form>
                            <?php elseif($ip->status === 'reserved'): ?>
                                <form action="<?php echo e(route('ip.release', $ip->id)); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="btn btn-sm btn-success"><?php echo e(__('Release')); ?></button>
                                </form>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\vmmgr.local\resources\views/subnets/ip_list.blade.php ENDPATH**/ ?>