<?php $__env->startSection('title', 'Settings Management'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">

            <!-- Проверка обновлений -->
            <form action="<?php echo e(route('check_update')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <button type="submit" class="btn btn-info btn-sm mb-3">Проверить обновления</button> | <label>Текущая версия <?php echo e(env("APP_VERSION")); ?></label>
            </form>


            <?php if(session('update_available')): ?>
                <form action="<?php echo e(route('update_panel')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-warning">Обновить панель</button>
                </form>
            <?php endif; ?>

            <hr>

            <a href="<?php echo e(route('settings.create')); ?>" class="btn btn-primary mb-3">Добавить настройки</a>
            <form action="<?php echo e(route('settings.update')); ?>" method="POST">
                <?php echo csrf_field(); ?>

                <h4>Настройки</h4>
                <?php $__currentLoopData = $settings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $setting): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="form-group">
                        <label for="setting-<?php echo e($setting->key); ?>"><?php echo e(ucfirst(str_replace('_', ' ', $setting->key))); ?></label>
                        <input type="text" name="settings[<?php echo e($setting->key); ?>]" class="form-control" value="<?php echo e($setting->value); ?>">
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <h4>Настройки хранилища</h4>
                <?php $__currentLoopData = $pools; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pool): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="form-group">
                        <label for="pool-<?php echo e($pool->id); ?>-name">Название пула</label>
                        <input type="text" name="pool[<?php echo e($pool->id); ?>][name]" class="form-control" value="<?php echo e($pool->name); ?>">
                    </div>

                    <div class="form-group">
                        <label for="pool-<?php echo e($pool->id); ?>-path">Путь для пула</label>
                        <input type="text" name="pool[<?php echo e($pool->id); ?>][path]" class="form-control" value="<?php echo e($pool->path); ?>">
                    </div>

                    <div class="form-group">
                        <label for="pool-<?php echo e($pool->id); ?>-type">Тип</label>
                        <select name="pool[<?php echo e($pool->id); ?>][type]" class="form-control">
                            <option value="file_system" <?php echo e($pool->type == 'file_system' ? 'selected' : ''); ?>>File System</option>
                            <option value="lvm" <?php echo e($pool->type == 'lvm' ? 'selected' : ''); ?>>LVM</option>
                            <option value="net_lvm" <?php echo e($pool->type == 'net_lvm' ? 'selected' : ''); ?>>Net LVM</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="pool-<?php echo e($pool->id); ?>-format_disk">Формат</label>
                        <select name="pool[<?php echo e($pool->id); ?>][format_disk]" class="form-control">
                            <option value="qcow2" <?php echo e($pool->format_disk == 'qcow2' ? 'selected' : ''); ?>>QCOW2</option>
                            <option value="raw" <?php echo e($pool->format_disk == 'raw' ? 'selected' : ''); ?>>RAW</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="pool-<?php echo e($pool->id); ?>-reserve">Резерв (в %)</label>
                        <input type="text" name="pool[<?php echo e($pool->id); ?>][reserve]" class="form-control" value="<?php echo e($pool->reserve); ?>">
                    </div>

                    <div class="form-group">
                        <label for="pool-<?php echo e($pool->id); ?>-cache_disk">Кэшировать диск</label>
                        <select name="pool[<?php echo e($pool->id); ?>][cache_disk]" class="form-control">
                            <option value="writethrough" <?php echo e($pool->cache_disk == 'writethrough' ? 'selected' : ''); ?>>Writethrough</option>
                            <option value="none" <?php echo e($pool->cache_disk == 'none' ? 'selected' : ''); ?>>None</option>
                        </select>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <button type="submit" class="btn btn-success">Сохранить</button>
            </form>
        </div>
    </div>

    <!-- Управление репозиториями ОС -->
    <div class="card mt-4">
        <div class="card-body">
            <h4>Управление репозиториями ОС</h4>
            <form action="<?php echo e(route('repository.store')); ?>" method="POST" class="mb-3">
                <?php echo csrf_field(); ?>
                <div class="form-group">
                    <label for="repository-url">Добавить репозиторий ОС</label>
                    <input type="text" name="url" class="form-control" placeholder="URL к info.json" required>
                </div>
                <button type="submit" class="btn btn-primary">Добавить</button>
            </form>

            <h5>Список репозиториев</h5>
            <table class="table">
                <thead>
                <tr>
                    <th>URL</th>
                    <th>Описание</th>
                    <th>Действия</th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $repositories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $repository): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($repository->url); ?></td>
                        <td><?php echo e($repository->description); ?></td>
                        <td>
                            <form action="<?php echo e(route('repository.destroy', $repository->id)); ?>" method="POST" onsubmit="return confirm('Вы уверены, что хотите удалить этот репозиторий?');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-danger">Удалить</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\vmmgr.local\resources\views/settings/index.blade.php ENDPATH**/ ?>