<?php $__env->startSection('title', __('messages.virtual_machines_management')); ?>
<?php $__env->startSection('header', __('messages.virtual_machines')); ?>
<?php $__env->startSection('breadcrumb', __('messages.virtual_machines')); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h3 class="card-title"><?php echo e(__('messages.virtual_machines_list')); ?></h3>
            <a href="<?php echo e(route('virtual_machines.create')); ?>" class="btn btn-primary float-right"><?php echo e(__('messages.add_virtual_machine')); ?></a>
        </div>
        <div class="card-body">

            <!-- Форма поиска -->
            <form action="<?php echo e(route('virtual_machines.index')); ?>" method="GET" class="form-inline mb-3">
                <div class="form-group mr-2">
                    <input type="text" name="search" class="form-control" placeholder="<?php echo e(__('messages.search_by_name')); ?>" value="<?php echo e(request('search')); ?>">
                </div>
                <button type="submit" class="btn btn-secondary"><?php echo e(__('messages.search')); ?></button>
            </form>

            <!-- Массовые действия -->
            <form action="<?php echo e(route('virtual_machines.bulk_action')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="mb-3">
                    <button type="submit" name="action" value="migrate" class="btn btn-warning"><?php echo e(__('messages.migrate_selected')); ?></button>
                    <button type="submit" name="action" value="stop" class="btn btn-secondary"><?php echo e(__('messages.stop_selected')); ?></button>
                    <button type="submit" name="action" value="start" class="btn btn-success"><?php echo e(__('messages.start_selected')); ?></button>
                    <button type="submit" name="action" value="reinstall" class="btn btn-danger"><?php echo e(__('messages.reinstall_selected')); ?></button>
                </div>

                <table class="table table-bordered table-sm">
                    <thead>
                    <tr>
                        <th><input type="checkbox" id="select-all"></th>
                        <th>ID</th>
                        <th><?php echo e(__('messages.name')); ?></th>
                        <th><?php echo e(__('messages.node')); ?></th>
                        <th><?php echo e(__('messages.status')); ?></th>
                        <th><?php echo e(__('messages.actions')); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $virtualMachines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><input type="checkbox" name="selected_vms[]" value="<?php echo e($vm->id); ?>"></td>
                            <td><?php echo e($vm->id); ?></td>
                            <td><?php echo e($vm->vm_name); ?></td>
                            <td><?php echo e($vm->node->name); ?></td>
                            <td><?php echo e($vm->status); ?></td>
                            <td class="text-center">
                                <a href="<?php echo e(route('virtual_machines.edit', $vm->id)); ?>" class="btn btn-sm btn-warning"><?php echo e(__('messages.edit')); ?></a>
                                <form action="<?php echo e(route('virtual_machines.destroy', $vm->id)); ?>" method="POST" style="display:inline;" onsubmit="return confirm('<?php echo e(__('messages.delete_confirmation')); ?>');">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger"><?php echo e(__('messages.delete')); ?></button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </form>
        </div>
    </div>

    <script>
        document.getElementById('select-all').addEventListener('click', function(event) {
            var checkboxes = document.querySelectorAll('input[type="checkbox"][name="selected_vms[]"]');
            for (var checkbox of checkboxes) {
                checkbox.checked = event.target.checked;
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\vmmgr.local\resources\views/virtual_machines/index.blade.php ENDPATH**/ ?>