<?php $__env->startSection('title', __('messages.host_nodes_management')); ?>
<?php $__env->startSection('header', __('messages.host_nodes_management')); ?>
<?php $__env->startSection('breadcrumb', __('messages.host_nodes_management')); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h3 class="card-title"><?php echo e(__('messages.host_nodes_list')); ?></h3>
            <a href="<?php echo e(route('host_nodes.create')); ?>" class="btn btn-success btn-sm ml-auto">
                <i class="fas fa-plus"></i>
            </a>
        </div>
        <div class="card-body">
            <!-- Форма поиска -->
            <form action="<?php echo e(route('host_nodes.index')); ?>" method="GET" class="mb-3">
                <div class="input-group">
                    <input type="text" name="search" class="form-control" placeholder="<?php echo e(__('messages.search_placeholder')); ?>" value="<?php echo e(request('search')); ?>">
                    <div class="input-group-append">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-search"></i> <?php echo e(__('messages.search')); ?>

                        </button>
                    </div>
                </div>
            </form>

            <!-- Таблица узлов -->
            <table class="table table-hover table-bordered">
                <thead class="thead-light">
                <tr>
                    <th><?php echo e(__('messages.id')); ?></th>
                    <th><?php echo e(__('messages.name')); ?></th>
                    <th><?php echo e(__('messages.ip_address')); ?></th>
                    <th class="text-center"><?php echo e(__('messages.status')); ?></th>
                    <th class="text-center"><?php echo e(__('messages.actions')); ?></th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $hostNodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hostNode): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($hostNode->id); ?></td>
                        <td><?php echo e($hostNode->name); ?></td>
                        <td><?php echo e($hostNode->ip_address); ?></td>
                        <td class="text-center">
                            <?php switch($hostNode->status):
                                case ('active'): ?>
                                    <span class="badge badge-success">
                                        <i class="fas fa-check-circle"></i> <?php echo e(__('messages.active')); ?>

                                    </span>
                                    <?php break; ?>
                                <?php case ('inactive'): ?>
                                    <span class="badge badge-warning">
                                        <i class="fas fa-times-circle"></i> <?php echo e(__('messages.inactive')); ?>

                                    </span>
                                    <?php break; ?>
                                <?php case ('error'): ?>
                                    <span class="badge badge-danger">
                                        <i class="fas fa-exclamation-triangle"></i> <?php echo e(__('messages.error')); ?>

                                    </span>
                                    <?php break; ?>
                                <?php case ('installing'): ?>
                                    <span class="badge badge-info">
                                        <i class="fas fa-cogs"></i> <?php echo e(__('messages.installing')); ?>

                                    </span>
                                    <?php break; ?>
                            <?php endswitch; ?>
                        </td>
                        <td class="text-center">
                            <a href="<?php echo e(route('host_nodes.edit', $hostNode->id)); ?>" class="btn btn-sm btn-warning mr-1">
                                <i class="fas fa-edit"></i> <?php echo e(__('messages.edit')); ?>

                            </a>
                            <form action="<?php echo e(route('host_nodes.destroy', $hostNode->id)); ?>" method="POST" style="display:inline;" onsubmit="return confirm('<?php echo e(__('messages.delete_confirmation')); ?>');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-danger">
                                    <i class="fas fa-trash-alt"></i> <?php echo e(__('messages.delete')); ?>

                                </button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\vmmgr.local\resources\views/host_nodes/index.blade.php ENDPATH**/ ?>