<!-- resources/views/dashboard/index.blade.php -->


<?php $__env->startSection('title', __('messages.dashboard')); ?>
<?php $__env->startSection('header', __('messages.dashboard')); ?>
<?php $__env->startSection('breadcrumb', __('messages.dashboard')); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <!-- Info boxes -->
        <div class="row">
            <!-- Cluster Nodes Count -->
            <div class="col-12 col-sm-6 col-md-3">
                <div class="info-box">
                    <span class="info-box-icon bg-info elevation-1"><i class="fas fa-server"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text"><?php echo e(__('messages.cluster_nodes')); ?></span>
                        <span class="info-box-number">
                            <?php echo e(rand(5, 20)); ?>

                        </span>
                    </div>
                </div>
            </div>

            <!-- Technical Nodes Count -->
            <div class="col-12 col-sm-6 col-md-3">
                <div class="info-box">
                    <span class="info-box-icon bg-secondary elevation-1"><i class="fas fa-cogs"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text"><?php echo e(__('messages.technical_nodes')); ?></span>
                        <span class="info-box-number">
                            <?php echo e(rand(1, 10)); ?>

                        </span>
                    </div>
                </div>
            </div>

            <!-- Virtual Machines Count -->
            <div class="col-12 col-sm-6 col-md-3">
                <div class="info-box">
                    <span class="info-box-icon bg-success elevation-1"><i class="fas fa-hdd"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text"><?php echo e(__('messages.virtual_machines')); ?></span>
                        <span class="info-box-number">
                            <?php echo e(rand(50, 200)); ?>

                        </span>
                    </div>
                </div>
            </div>

            <!-- Users Count -->
            <div class="col-12 col-sm-6 col-md-3">
                <div class="info-box">
                    <span class="info-box-icon bg-warning elevation-1"><i class="fas fa-users"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text"><?php echo e(__('messages.users')); ?></span>
                        <span class="info-box-number">
                            <?php echo e(rand(10, 100)); ?>

                        </span>
                    </div>
                </div>
            </div>

        </div>

        <!-- Top 10 Virtual Machines by Load -->
        <div class="row">
            <div class="col-12 col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title"><?php echo e(__('messages.top_10_virtual_machines')); ?></h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered table-hover">
                            <thead>
                            <tr>
                                <th><?php echo e(__('messages.name')); ?></th>
                                <th><?php echo e(__('messages.cpu_usage')); ?></th>
                                <th><?php echo e(__('messages.ram_usage')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php for($i = 0; $i < 10; $i++): ?>
                                <tr>
                                    <td>VM-<?php echo e($i + 1); ?></td>
                                    <td><?php echo e(rand(10, 100)); ?>%</td>
                                    <td><?php echo e(rand(10, 100)); ?>%</td>
                                </tr>
                            <?php endfor; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Top 10 Cluster Nodes by Load -->
            <div class="col-12 col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title"><?php echo e(__('messages.top_10_nodes')); ?></h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered table-hover">
                            <thead>
                            <tr>
                                <th><?php echo e(__('messages.name')); ?></th>
                                <th><?php echo e(__('messages.cpu_usage')); ?></th>
                                <th><?php echo e(__('messages.ram_usage')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php for($i = 0; $i < 10; $i++): ?>
                                <tr>
                                    <td>Node-<?php echo e($i + 1); ?></td>
                                    <td><?php echo e(rand(10, 100)); ?>%</td>
                                    <td><?php echo e(rand(10, 100)); ?>%</td>
                                </tr>
                            <?php endfor; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Top Users by Load and VM Count -->
        <div class="row">
            <div class="col-12 col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title"><?php echo e(__('messages.top_users_by_load')); ?></h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered table-hover">
                            <thead>
                            <tr>
                                <th><?php echo e(__('messages.user_name')); ?></th>
                                <th><?php echo e(__('messages.total_load')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php for($i = 0; $i < 5; $i++): ?>
                                <tr>
                                    <td>User-<?php echo e($i + 1); ?></td>
                                    <td><?php echo e(rand(100, 1000)); ?>%</td>
                                </tr>
                            <?php endfor; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="col-12 col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title"><?php echo e(__('messages.top_users_by_vm_count')); ?></h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered table-hover">
                            <thead>
                            <tr>
                                <th><?php echo e(__('messages.user_name')); ?></th>
                                <th><?php echo e(__('messages.vm_count')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php for($i = 0; $i < 5; $i++): ?>
                                <tr>
                                    <td>User-<?php echo e($i + 1); ?></td>
                                    <td><?php echo e(rand(1, 20)); ?></td>
                                </tr>
                            <?php endfor; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\vmmgr.local\resources\views/dashboard/index.blade.php ENDPATH**/ ?>