<?php $__env->startSection('title', 'Job Monitoring'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Jobs Monitoring</h3>
        </div>
        <div class="card-body">
            <table class="table table-bordered">
                <thead>
                <tr>
                    <th>ID</th>
                    <th>Job Name</th>
                    <th>Status</th>
                    <th>Started At</th>
                    <th>Finished At</th>
                    <th>Failed At</th>
                    <th>Message</th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $jobs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($job->id); ?></td>
                        <td><?php echo e($job->job_name); ?></td>
                        <td><?php echo e($job->status); ?></td>
                        <td><?php echo e($job->started_at ? $job->started_at->format('Y-m-d H:i:s') : 'N/A'); ?></td>
                        <td><?php echo e($job->finished_at ? $job->finished_at->format('Y-m-d H:i:s') : 'N/A'); ?></td>
                        <td><?php echo e($job->failed_at ? $job->failed_at->format('Y-m-d H:i:s') : 'N/A'); ?></td>
                        <td><?php echo e($job->exception ?? 'No errors'); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            <?php echo e($jobs->links()); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\vmmgr.local\resources\views/jobs_monitoring/index.blade.php ENDPATH**/ ?>