<?php $__env->startSection('title', 'Активные сессии'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Активные сессии пользователей</h3>
        </div>
        <div class="card-body">
            <table class="table table-bordered table-sm">
                <thead>
                <tr>
                    <th>ID сессии</th>
                    <th>Пользователь</th>
                    <th>Email</th>
                    <th>IP адрес</th>
                    <th>Последняя активность</th>
                    <th>Действия</th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $sessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($session->id); ?></td>
                        <td><?php echo e($session->name); ?></td>
                        <td><?php echo e($session->email); ?></td>
                        <td><?php echo e($session->ip_address); ?></td>
                        <td><?php echo e(\Carbon\Carbon::createFromTimestamp($session->last_activity)->diffForHumans()); ?></td>
                        <td>
                            <form action="<?php echo e(route('sessions.destroy', $session->id)); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Вы уверены, что хотите завершить эту сессию?');">
                                    Завершить сессию
                                </button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\vmmgr.local\resources\views/sessions/index.blade.php ENDPATH**/ ?>