<?php $__env->startSection('title', 'User Settings'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">
        <h2>User Settings</h2>
        <?php if(session('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <!-- Change Password Form -->
        <form action="<?php echo e(route('user.update.password')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="form-group">
                <label for="current_password">Current Password</label>
                <input type="password" name="current_password" class="form-control" required>
            </div>
            <div class="form-group">
                <label for="new_password">New Password</label>
                <input type="password" name="new_password" class="form-control" required>
            </div>
            <div class="form-group">
                <label for="new_password_confirmation">Confirm New Password</label>
                <input type="password" name="new_password_confirmation" class="form-control" required>
            </div>
            <button type="submit" class="btn btn-primary">Update Password</button>
        </form>

        <!-- IP Restrictions Form -->
        <form action="<?php echo e(route('user.update.ip_restrictions')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="form-group">
                <label for="ip_restrictions">Allowed IPs (comma separated)</label>
                <textarea name="ip_restrictions" class="form-control"><?php echo e(auth()->user()->ip_restrictions); ?></textarea>
            </div>
            <button type="submit" class="btn btn-primary">Update IP Restrictions</button>
        </form>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\vmmgr.local\resources\views/user/settings.blade.php ENDPATH**/ ?>