<?php $__env->startSection('title', 'Virtual Machine Templates'); ?>
<?php $__env->startSection('header', 'Virtual Machine Templates'); ?>
<?php $__env->startSection('breadcrumb', 'Templates'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Template List</h3>
            <a href="<?php echo e(route('templates.create')); ?>" class="btn btn-primary float-right">Add Template</a>
        </div>
        <div class="card-body">
            <table class="table table-bordered table-sm">
                <thead>
                <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th>CPU</th>
                    <th>Memory (MB)</th>
                    <th>Disk Size (GB)</th>
                    <th>Network Bridge</th>
                    <th>Actions</th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($template->id); ?></td>
                        <td><?php echo e($template->template_name); ?></td>
                        <td><?php echo e($template->cpu); ?></td>
                        <td><?php echo e($template->memory); ?></td>
                        <td><?php echo e($template->disk_size); ?></td>
                        <td><?php echo e($template->network_bridge); ?></td>
                        <td class="text-center">
                            <a href="<?php echo e(route('templates.edit', $template->id)); ?>" class="btn btn-sm btn-warning">Edit</a>
                            <form action="<?php echo e(route('templates.destroy', $template->id)); ?>" method="POST" style="display:inline;" onsubmit="return confirm('Are you sure you want to delete this template?');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-danger">Delete</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\vmmgr.local\resources\views/templates/index.blade.php ENDPATH**/ ?>