<?php

use App\Http\Controllers\FirewallController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserController;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\HostNodeController;
use App\Http\Controllers\VirtualMachineController;
use App\Http\Controllers\LanguageController;
use App\Http\Middleware\LanguageMiddleware;
use App\Http\Controllers\SubnetController;
use App\Http\Controllers\JobMonitoringController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\UserSettingsController;
use App\Http\Controllers\TemplateOsController;
use App\Http\Controllers\VirtualMachineTemplateController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\NodeMetricsController;
use App\Http\Controllers\RepositoryController;
use App\Http\Controllers\SessionController;



//Route::get('/install', [InstallerController::class, 'index'])->name('install.index');
//Route::post('/install', [InstallerController::class, 'install'])->name('install.perform');


Route::post('/node-metrics', [NodeMetricsController::class, 'store']);

Auth::routes();

Route::middleware([LanguageMiddleware::class])->group(function () {
    Route::get('/lang/{lang}', [LanguageController::class, 'switchLanguage'])->name('switch_language');

    Route::middleware(['auth'])->group(function () {

        Route::get('/dashboard', [App\Http\Controllers\DashboardController::class, 'index'])->name('dashboard');


        Route::get('/users', [UserController::class, 'index'])->name('users');

        Route::resource('templates', VirtualMachineTemplateController::class);

        Route::get('user/settings', [UserSettingsController::class, 'showSettings'])->name('user.settings');
        Route::post('user/settings/password', [UserSettingsController::class, 'updatePassword'])->name('user.update.password');
        Route::post('user/settings/two-factor', [UserSettingsController::class, 'updateTwoFactor'])->name('user.update.two_factor');
        Route::post('user/settings/ip-restrictions', [UserSettingsController::class, 'updateIpRestrictions'])->name('user.update.ip_restrictions');

        Route::prefix('users')->name('users.')->group(function () {
            Route::get('/', [UserController::class, 'index'])->name('index');
            Route::get('/create', [UserController::class, 'create'])->name('create');
            Route::post('/store', [UserController::class, 'store'])->name('store');
            Route::get('/{user}/edit', [UserController::class, 'edit'])->name('edit');
            Route::put('/{user}', [UserController::class, 'update'])->name('update');
            Route::delete('/{user}', [UserController::class, 'destroy'])->name('destroy');
            Route::put('/{user}/change-password', [UserController::class, 'changePassword'])->name('change-password');
            Route::put('/{user}/block', [UserController::class, 'block'])->name('block');
        });

        // Роуты для управления ролями
        Route::prefix('roles')->name('roles.')->group(function () {
            Route::get('/', [RoleController::class, 'index'])->name('index');
            Route::get('/create', [RoleController::class, 'create'])->name('create');
            Route::post('/store', [RoleController::class, 'store'])->name('store');
            Route::get('/{role}/edit', [RoleController::class, 'edit'])->name('edit');
            Route::put('/{role}', [RoleController::class, 'update'])->name('update');
            Route::delete('/{role}', [RoleController::class, 'destroy'])->name('destroy');
        });

        // Роуты для управления правами доступа
        Route::prefix('permissions')->name('permissions.')->group(function () {
            Route::get('/', [PermissionController::class, 'index'])->name('index');
            Route::get('/create', [PermissionController::class, 'create'])->name('create');
            Route::post('/store', [PermissionController::class, 'store'])->name('store');
            Route::get('/{permission}/edit', [PermissionController::class, 'edit'])->name('edit');
            Route::put('/{permission}', [PermissionController::class, 'update'])->name('update');
            Route::delete('/{permission}', [PermissionController::class, 'destroy'])->name('destroy');
        });

        // Роуты для управления узлами кластера
        Route::prefix('host_nodes')->name('host_nodes.')->group(function () {
            Route::get('/', [HostNodeController::class, 'index'])->name('index');
            Route::get('/create', [HostNodeController::class, 'create'])->name('create');
            Route::post('/store', [HostNodeController::class, 'store'])->name('store');
            Route::get('/{host_node}/edit', [HostNodeController::class, 'edit'])->name('edit');
            Route::put('/{host_node}', [HostNodeController::class, 'update'])->name('update');
            Route::delete('/{host_node}', [HostNodeController::class, 'destroy'])->name('destroy');
            Route::get('/{host_node}', [HostNodeController::class, 'show'])->name('show');
        });

        Route::middleware(['auth'])->prefix('virtual_machines')->name('virtual_machines.')->group(function () {
            Route::get('/', [VirtualMachineController::class, 'index'])->name('index');
            Route::get('/create', [VirtualMachineController::class, 'create'])->name('create');
            Route::post('/store', [VirtualMachineController::class, 'store'])->name('store');
            Route::get('/{virtualMachine}/edit', [VirtualMachineController::class, 'edit'])->name('edit');
            Route::put('/{virtualMachine}', [VirtualMachineController::class, 'update'])->name('update');
            Route::delete('/{virtualMachine}', [VirtualMachineController::class, 'destroy'])->name('destroy');
            Route::post('/bulk_action', [VirtualMachineController::class, 'bulkAction'])->name('bulk_action'); // Исправленный маршрут
        });

        Route::middleware(['auth'])->prefix('subnets')->name('subnets.')->group(function () {
            Route::get('/', [SubnetController::class, 'index'])->name('index');
            Route::get('/create', [SubnetController::class, 'create'])->name('create');
            Route::post('/store', [SubnetController::class, 'store'])->name('store');
            Route::get('/{subnet}/edit', [SubnetController::class, 'edit'])->name('edit');
            Route::put('/{subnet}', [SubnetController::class, 'update'])->name('update');
            Route::delete('/{subnet}', [SubnetController::class, 'destroy'])->name('destroy');

            // Путь для отображения IP-адресов
            Route::get('/{subnet}/ips', [SubnetController::class, 'showIps'])->name('show_ips');

            // Резервирование и освобождение IP-адресов
            Route::post('/ip/{id}/reserve', [SubnetController::class, 'reserveIp'])->name('ip.reserve');
            Route::post('/ip/{id}/release', [SubnetController::class, 'releaseIp'])->name('ip.release');
            Route::post('/ip/{id}/comment', [SubnetController::class, 'saveComment'])->name('ip.comment');
        });


        Route::get('/jobs-monitoring', [JobMonitoringController::class, 'index'])->name('jobs.monitoring');
        Route::get('/queue-count', [DashboardController::class, 'getQueueCount'])->name('queue.count');

        Route::prefix('template_os')->name('template_os.')->group(function () {
            Route::get('/', [TemplateOsController::class, 'index'])->name('index');
            Route::get('/refresh', [TemplateOsController::class, 'refresh'])->name('refresh');
            Route::post('/download/{id}', [TemplateOsController::class, 'download'])->name('os.download');
            Route::post('/reinstall/{id}', [TemplateOsController::class, 'reinstall'])->name('os.reinstall');
            Route::delete('/delete/{id}', [TemplateOsController::class, 'delete'])->name('os.delete');
            Route::post('/download_from_repo', [TemplateOsController::class, 'downloadFromRepo'])->name('os.download_from_repo');
            Route::post('/download_multiple', [TemplateOsController::class, 'downloadMultipleFromRepo'])->name('os.download_multiple');

        });

        Route::middleware(['auth'])->group(function () {
            Route::get('/settings', [SettingsController::class, 'index'])->name('settings.index');
            Route::post('/settings', [SettingsController::class, 'update'])->name('settings.update');
            Route::get('/settings/create', [SettingsController::class, 'create'])->name('settings.create');
            Route::post('/settings/store', [SettingsController::class, 'store'])->name('settings.store');
            Route::post('/check-update', [SettingsController::class, 'checkUpdate'])->name('check_update');
            Route::post('/update-panel', [SettingsController::class, 'updatePanel'])->name('update_panel');
            Route::post('/firewall/sync', [FirewallController::class, 'sync'])->name('firewall.sync');
        });

        Route::post('/repository/store', [RepositoryController::class, 'store'])->name('repository.store');
        Route::delete('/repository/{id}', [RepositoryController::class, 'destroy'])->name('repository.destroy');

        Route::get('/sessions', [SessionController::class, 'index'])->name('sessions.index');
        Route::delete('/sessions/{id}', [SessionController::class, 'destroy'])->name('sessions.destroy');

//        // Управление репозиториями
//        Route::get('/repositories', [RepositoryController::class, 'index'])->name('repositories.index');
//        Route::get('/repositories/create', [RepositoryController::class, 'create'])->name('repositories.create');
//        Route::post('/repositories', [RepositoryController::class, 'store'])->name('repositories.store');
//
//// Управление ОС
//        Route::get('/os', [OSController::class, 'index'])->name('os.index');
//        Route::get('/os/download/{id}', [OSController::class, 'download'])->name('os.download');
//        Route::get('/os/reload/{id}', [OSController::class, 'reload'])->name('os.reload');

    });
});
