@extends('layouts.app')

@section('title', __('messages.virtual_machines_management'))
@section('header', __('messages.virtual_machines'))
@section('breadcrumb', __('messages.virtual_machines'))

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">{{ __('messages.virtual_machines_list') }}</h3>
            <a href="{{ route('virtual_machines.create') }}" class="btn btn-primary float-right">{{ __('messages.add_virtual_machine') }}</a>
        </div>
        <div class="card-body">

            <!-- Форма поиска -->
            <form action="{{ route('virtual_machines.index') }}" method="GET" class="form-inline mb-3">
                <div class="form-group mr-2">
                    <input type="text" name="search" class="form-control" placeholder="{{ __('messages.search_by_name') }}" value="{{ request('search') }}">
                </div>
                <button type="submit" class="btn btn-secondary">{{ __('messages.search') }}</button>
            </form>

            <!-- Массовые действия -->
            <form action="{{ route('virtual_machines.bulk_action') }}" method="POST">
                @csrf
                <div class="mb-3">
                    <button type="submit" name="action" value="migrate" class="btn btn-warning">{{ __('messages.migrate_selected') }}</button>
                    <button type="submit" name="action" value="stop" class="btn btn-secondary">{{ __('messages.stop_selected') }}</button>
                    <button type="submit" name="action" value="start" class="btn btn-success">{{ __('messages.start_selected') }}</button>
                    <button type="submit" name="action" value="reinstall" class="btn btn-danger">{{ __('messages.reinstall_selected') }}</button>
                </div>

                <table class="table table-bordered table-sm">
                    <thead>
                    <tr>
                        <th><input type="checkbox" id="select-all"></th>
                        <th>ID</th>
                        <th>{{ __('messages.name') }}</th>
                        <th>{{ __('messages.node') }}</th>
                        <th>{{ __('messages.status') }}</th>
                        <th>{{ __('messages.actions') }}</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($virtualMachines as $vm)
                        <tr>
                            <td><input type="checkbox" name="selected_vms[]" value="{{ $vm->id }}"></td>
                            <td>{{ $vm->id }}</td>
                            <td>{{ $vm->vm_name }}</td>
                            <td>{{ $vm->node->name }}</td>
                            <td>{{ $vm->status }}</td>
                            <td class="text-center">
                                <a href="{{ route('virtual_machines.edit', $vm->id) }}" class="btn btn-sm btn-warning">{{ __('messages.edit') }}</a>
                                <form action="{{ route('virtual_machines.destroy', $vm->id) }}" method="POST" style="display:inline;" onsubmit="return confirm('{{ __('messages.delete_confirmation') }}');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger">{{ __('messages.delete') }}</button>
                                </form>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </form>
        </div>
    </div>

    <script>
        document.getElementById('select-all').addEventListener('click', function(event) {
            var checkboxes = document.querySelectorAll('input[type="checkbox"][name="selected_vms[]"]');
            for (var checkbox of checkboxes) {
                checkbox.checked = event.target.checked;
            }
        });
    </script>
@endsection
