@extends('layouts.app')

@section('title', __('messages.edit_virtual_machine'))
@section('header', __('messages.edit_virtual_machine'))
@section('breadcrumb', __('messages.edit_virtual_machine'))

@section('content')
    <div class="card">
        <div class="card-body">
            <form action="{{ route('virtual_machines.update', $virtualMachine->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="form-group">
                    <label for="vm_name">{{ __('messages.name') }}</label>
                    <input type="text" name="vm_name" class="form-control" value="{{ $virtualMachine->vm_name }}" required>
                </div>
                <div class="form-group">
                    <label for="node_id">{{ __('messages.node') }}</label>
                    <select name="node_id" class="form-control" required>
                        @foreach($nodes as $node)
                            <option value="{{ $node->id }}" {{ $virtualMachine->node_id == $node->id ? 'selected' : '' }}>{{ $node->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="form-group">
                    <label for="cpu">{{ __('messages.cpu') }}</label>
                    <input type="number" name="cpu" class="form-control" value="{{ $virtualMachine->cpu }}" required>
                </div>
                <div class="form-group">
                    <label for="memory">{{ __('messages.memory') }}</label>
                    <input type="number" name="memory" class="form-control" value="{{ $virtualMachine->memory }}" required>
                </div>
                <div class="form-group">
                    <label for="disk_size">{{ __('messages.disk_size') }}</label>
                    <input type="number" name="disk_size" class="form-control" value="{{ $virtualMachine->disk_size }}" required>
                </div>
                <div class="form-group">
                    <label for="description">{{ __('messages.description') }}</label>
                    <textarea name="description" class="form-control">{{ $virtualMachine->description }}</textarea>
                </div>
                <button type="submit" class="btn btn-success">{{ __('messages.update_virtual_machine') }}</button>
            </form>
        </div>
    </div>
@endsection
