@extends('layouts.app')

@section('title', __('messages.add_virtual_machine'))
@section('header', __('messages.add_virtual_machine'))
@section('breadcrumb', __('messages.add_virtual_machine'))

@section('content')
    <div class="card">
        <div class="card-body">
            @if($nodes->isEmpty())
                <div class="alert alert-danger">
                    {{ __('messages.no_active_nodes') }}
                </div>
            @else
                <form action="{{ route('virtual_machines.store') }}" method="POST">
                    @csrf
                    <div class="form-group">
                        <label for="vm_name">{{ __('messages.name') }}</label>
                        <input type="text" name="vm_name" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="node_id">{{ __('messages.node') }}</label>
                        <select name="node_id" class="form-control" required>
                            @foreach($nodes as $node)
                                <option value="{{ $node->id }}">{{ $node->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="cpu">{{ __('messages.cpu') }}</label>
                        <input type="number" name="cpu" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="memory">{{ __('messages.memory') }}</label>
                        <input type="number" name="memory" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="disk_size">{{ __('messages.disk_size') }}</label>
                        <input type="number" name="disk_size" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="description">{{ __('messages.description') }}</label>
                        <textarea name="description" class="form-control"></textarea>
                    </div>
                    <button type="submit" class="btn btn-success">{{ __('messages.add_virtual_machine') }}</button>
                </form>
            @endif
        </div>
    </div>
@endsection
