@extends('layouts.app')

@section('title', 'Users Management')
@section('header', 'Users')
@section('breadcrumb', 'Users')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Users List</h3>
            <a href="{{ route('users.create') }}" class="btn btn-primary float-right">Add User</a>
        </div>
        <div class="card-body">
            <!-- Форма поиска -->
            <form action="{{ route('users.index') }}" method="GET" class="form-inline mb-3">
                <div class="form-group mr-2">
                    <input type="text" name="search" class="form-control" placeholder="Search by name or email" value="{{ request('search') }}">
                </div>
                <button type="submit" class="btn btn-secondary">Поиск</button>
            </form>

            <table class="table table-bordered table-sm">
                <thead>
                <tr>
                    <th>ID</th>
                    <th>Логин</th>
                    <th>Email</th>
                    <th>Права</th>
                    <th>Статус</th>
                    <th>Действия</th>
                </tr>
                </thead>
                <tbody>
                @foreach($users as $user)
                    <tr>
                        <td>{{ $user->id }}</td>
                        <td>{{ $user->name }}</td>
                        <td>{{ $user->email }}</td>
                        <td>{{ $user->role->name }}</td>
                        <td class="text-center">
                            @if($user->is_active)
                                <span class="text-success"> Активен <i class="fas fa-check-circle"></i></span>
                            @else
                                <span class="text-danger"> Заблокирован <i class="fas fa-ban"></i></span>
                            @endif
                        </td>
                        <td class="text-center">
                            <a href="{{ route('users.edit', $user->id) }}" class="btn btn-sm btn-warning">Редактировать</a>
                            <form action="{{ route('users.destroy', $user->id) }}" method="POST" style="display:inline;" onsubmit="return confirm('Are you sure you want to delete this user?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger">Удалить</button>
                            </form>
                            <form action="{{ route('users.block', $user->id) }}" method="POST" style="display:inline;">
                                @csrf
                                @method('PUT')
                                <button type="submit" class="btn btn-sm btn-secondary">
                                    {{ $user->is_active ? 'Заблокировать' : 'Разблокировать' }}
                                </button>
                            </form>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>

            <!-- Пагинация -->
            {{ $users->links() }}
        </div>
    </div>
@endsection

<script>
    let formToDelete;

    document.querySelectorAll('form[action*="users.destroy"]').forEach(form => {
        form.addEventListener('submit', function(event) {
            event.preventDefault();
            formToDelete = form;
            $('#deleteConfirmationModal').modal('show');
        });
    });

    document.getElementById('confirmDeleteButton').addEventListener('click', function() {
        formToDelete.submit();
    });
</script>
