@extends('layouts.app')

@section('title', 'Edit User')
@section('header', 'Edit User')
@section('breadcrumb', 'Edit User')

@section('content')
    <div class="card">
        <div class="card-body">
            <form action="{{ route('users.update', $user->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="form-group">
                    <label for="name">Name</label>
                    <input type="text" name="name" class="form-control" value="{{ $user->name }}" required>
                </div>
                <div class="form-group">
                    <label for="email">Email</label>
                    <input type="email" name="email" class="form-control" value="{{ $user->email }}" required>
                </div>
                <div class="form-group">
                    <label for="role_id">Role</label>
                    <select name="role_id" class="form-control" required>
                        @foreach($roles as $role)
                            <option value="{{ $role->id }}" {{ $user->role_id == $role->id ? 'selected' : '' }}>
                                {{ $role->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <!-- Поле для смены пароля -->
                <div class="form-group">
                    <label for="password">New Password</label>
                    <input type="text" name="password" class="form-control" id="password">
                </div>
                <div class="form-group">
                    <label for="password_confirmation">Confirm New Password</label>
                    <input type="password" name="password_confirmation" class="form-control" id="password_confirmation">
                </div>
                <!-- Кнопка для генерации пароля -->
                <div class="form-group">
                    <button type="button" class="btn btn-secondary" onclick="generatePassword()">Generate Password</button>
                </div>
                <button type="submit" class="btn btn-success">Update User</button>
            </form>
        </div>
    </div>

    <!-- Добавление скрипта для генерации пароля -->
    <script>
        function generatePassword() {
            const password = Math.random().toString(36).slice(-8);
            document.getElementById('password').value = password;
            document.getElementById('password_confirmation').value = password;
        }
    </script>
@endsection
