@extends('layouts.app')

@section('title', 'User Settings')

@section('content')
    <div class="container">
        <h2>User Settings</h2>
        @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
        @endif

        <!-- Change Password Form -->
        <form action="{{ route('user.update.password') }}" method="POST">
            @csrf
            <div class="form-group">
                <label for="current_password">Current Password</label>
                <input type="password" name="current_password" class="form-control" required>
            </div>
            <div class="form-group">
                <label for="new_password">New Password</label>
                <input type="password" name="new_password" class="form-control" required>
            </div>
            <div class="form-group">
                <label for="new_password_confirmation">Confirm New Password</label>
                <input type="password" name="new_password_confirmation" class="form-control" required>
            </div>
            <button type="submit" class="btn btn-primary">Update Password</button>
        </form>

        <!-- IP Restrictions Form -->
        <form action="{{ route('user.update.ip_restrictions') }}" method="POST">
            @csrf
            <div class="form-group">
                <label for="ip_restrictions">Allowed IPs (comma separated)</label>
                <textarea name="ip_restrictions" class="form-control">{{ auth()->user()->ip_restrictions }}</textarea>
            </div>
            <button type="submit" class="btn btn-primary">Update IP Restrictions</button>
        </form>
    </div>
@endsection
