@extends('layouts.app')

@section('title', 'Virtual Machine Templates')
@section('header', 'Virtual Machine Templates')
@section('breadcrumb', 'Templates')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Template List</h3>
            <a href="{{ route('templates.create') }}" class="btn btn-primary float-right">Add Template</a>
        </div>
        <div class="card-body">
            <table class="table table-bordered table-sm">
                <thead>
                <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th>CPU</th>
                    <th>Memory (MB)</th>
                    <th>Disk Size (GB)</th>
                    <th>Network Bridge</th>
                    <th>Actions</th>
                </tr>
                </thead>
                <tbody>
                @foreach($templates as $template)
                    <tr>
                        <td>{{ $template->id }}</td>
                        <td>{{ $template->template_name }}</td>
                        <td>{{ $template->cpu }}</td>
                        <td>{{ $template->memory }}</td>
                        <td>{{ $template->disk_size }}</td>
                        <td>{{ $template->network_bridge }}</td>
                        <td class="text-center">
                            <a href="{{ route('templates.edit', $template->id) }}" class="btn btn-sm btn-warning">Edit</a>
                            <form action="{{ route('templates.destroy', $template->id) }}" method="POST" style="display:inline;" onsubmit="return confirm('Are you sure you want to delete this template?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger">Delete</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
