@extends('layouts.app')

@section('title', 'Edit Virtual Machine Template')
@section('header', 'Edit Template')
@section('breadcrumb', 'Edit Template')

@section('content')
    <div class="card">
        <div class="card-body">
            <form action="{{ route('templates.update', $template->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="form-group">
                    <label for="template_name">Template Name</label>
                    <input type="text" name="template_name" class="form-control" value="{{ $template->template_name }}" required>
                </div>
                <div class="form-group">
                    <label for="cpu">CPU</label>
                    <input type="number" name="cpu" class="form-control" value="{{ $template->cpu }}" required>
                </div>
                <div class="form-group">
                    <label for="memory">Memory (MB)</label>
                    <input type="number" name="memory" class="form-control" value="{{ $template->memory }}" required>
                </div>
                <div class="form-group">
                    <label for="disk_size">Disk Size (GB)</label>
                    <input type="number" name="disk_size" class="form-control" value="{{ $template->disk_size }}" required>
                </div>
                <div class="form-group">
                    <label for="network_bridge">Network Bridge</label>
                    <input type="text" name="network_bridge" class="form-control" value="{{ $template->network_bridge }}" required>
                </div>
                <div class="form-group">
                    <label for="cpu_emulation">CPU Emulation</label>
                    <select name="cpu_emulation" class="form-control" required>
                        <option value="host" {{ $template->cpu_emulation == 'host' ? 'selected' : '' }}>Host</option>
                        <option value="kvm64" {{ $template->cpu_emulation == 'kvm64' ? 'selected' : '' }}>KVM64</option>
                        <option value="qemu64" {{ $template->cpu_emulation == 'qemu64' ? 'selected' : '' }}>QEMU64</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="network_model">Network Model</label>
                    <select name="network_model" class="form-control" required>
                        <option value="virtio" selected>Virtio</option>
                        <option value="i82551">i82551</option>
                        <option value="i82557b">i82557b</option>
                        <option value="i82559er">i82559er</option>
                        <option value="ne2k_pci">ne2k_pci</option>
                        <option value="pcnet">pcnet</option>
                        <option value="rtl8139">rtl8139</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="storage_pool_id">Storage Pool</label>
                    <select name="storage_pool_id" class="form-control" required>
                        @foreach($storagePools as $pool)
                            <option value="{{ $pool->id }}" {{ $template->storage_pool_id == $pool->id ? 'selected' : '' }}>{{ $pool->name }}</option>
                        @endforeach
                    </select>
                </div>
                <button type="submit" class="btn btn-success">Update Template</button>
            </form>
        </div>
    </div>
@endsection
