@extends('layouts.app')

@section('title', __('messages.template_os_management'))
@section('header', __('messages.template_os_management'))
@section('breadcrumb', __('messages.template_os_management'))

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">{{ __('messages.template_os_list') }}</h3>
        </div>
        <div class="card-body">
            <h4 class="text-info">{{ __('messages.installed_os') }}</h4>
            <table class="table table-hover table-striped table-bordered">
                <thead class="thead-light">
                <tr>
                    <th>#</th>
                    <th>{{ __('messages.name') }}</th>
                    <th>{{ __('messages.cpu_min') }}</th>
                    <th>{{ __('messages.ram_min') }}</th>
                    <th>{{ __('messages.disk_min') }}</th>
                    <th>{{ __('messages.archive_size') }}</th>
                    <th>{{ __('messages.local_size') }}</th>
                    <th>{{ __('messages.status') }}</th>
                    <th>{{ __('messages.actions') }}</th>
                </tr>
                </thead>
                <tbody>
                @foreach($templateOsList as $os)
                    <tr>
                        <td>{{ $os->id }}</td>
                        <td>{{ $os->name }}</td>
                        <td>{{ $os->cpu_min ?? __('messages.not_available') }}</td>
                        <td>{{ $os->ram_min ?? __('messages.not_available') }}</td>
                        <td>{{ $os->disk_min ?? __('messages.not_available') }}</td>
                        <td>{{ $os->archive_size ?? __('messages.not_available') }}</td>
                        <td>{{ $os->local_size ?? __('messages.not_available') }}</td>
                        <td>
                            @if($os->status === 'available')
                                <span class="badge badge-success">{{ __('messages.available') }}</span>
                            @elseif($os->status === 'installed')
                                <span class="badge badge-primary">{{ __('messages.installed') }}</span>
                            @else
                                <span class="badge badge-secondary">{{ __('messages.unknown') }}</span>
                            @endif
                        </td>
                        <td class="text-center">
                            @if($os->status === 'installed')
                                <div class="btn-group">
                                    <form action="{{ route('os.delete', $os->id) }}" method="POST" onsubmit="return confirm('{{ __('messages.delete_confirmation') }}');" style="display:inline;">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger" title="{{ __('messages.delete') }}">
                                            <i class="fas fa-trash-alt"></i>
                                        </button>
                                    </form>
                                    <form action="{{ route('os.reinstall', $os->id) }}" method="POST" style="display:inline;">
                                        @csrf
                                        <button type="submit" class="btn btn-sm btn-warning" title="{{ __('messages.reinstall') }}">
                                            <i class="fas fa-sync-alt"></i>
                                        </button>
                                    </form>
                                </div>
                            @elseif($os->status === 'available')
                                <form action="{{ route('os.download', $os->id) }}" method="POST" style="display:inline;">
                                    @csrf
                                    <button type="submit" class="btn btn-sm btn-primary" title="{{ __('messages.download_and_install') }}">
                                        <i class="fas fa-download"></i>
                                    </button>
                                </form>
                            @endif
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>

            <hr class="my-4">

            <h4 class="text-info">{{ __('messages.available_os_repositories') }}</h4>

            <form action="{{ route('template_os.os.download_multiple') }}" method="POST">
                @csrf
                @foreach($osListFromRepositories as $repoIndex => $repo)
                    <div class="repository-section mb-4">
                        <h5 class="text-primary">{{ __('messages.repository') }} #{{ $repoIndex + 1 }}</h5>

                        @if(isset($repo['error']))
                            <div class="alert alert-danger">{{ $repo['error'] }}</div>
                        @else
                            <table class="table table-hover table-striped table-bordered">
                                <thead class="thead-dark">
                                <tr>
                                    <th>
                                        <input type="checkbox" id="select_all_{{ $repoIndex }}" onclick="toggleSelectAll({{ $repoIndex }})">
                                    </th>
                                    <th>{{ __('messages.name') }}</th>
                                    <th>{{ __('messages.version') }}</th>
                                    <th>{{ __('messages.cpu_min') }}</th>
                                    <th>{{ __('messages.ram_min') }}</th>
                                    <th>{{ __('messages.disk_min') }}</th>
                                    <th>{{ __('messages.archive_name') }}</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($repo['operating_systems'] as $os)
                                    <tr>
                                        <td><input type="checkbox" name="os_files[]" value="{{ $os['file'] }}" class="os-checkbox-{{ $repoIndex }}"></td>
                                        <td>{{ $os['name'] }}</td>
                                        <td>{{ implode(', ', $os['tags']) }}</td>
                                        <td>{{ $os['cpu_min'] ?? __('messages.not_available') }}</td>
                                        <td>{{ $os['ram_min'] ?? __('messages.not_available') }}</td>
                                        <td>{{ $os['disk_min'] ?? __('messages.not_available') }}</td>
                                        <td>{{ $os['file'] }}</td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        @endif
                    </div>
                @endforeach

                <div class="text-right">
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-download"></i> {{ __('messages.download_selected') }}
                    </button>
                </div>
            </form>
        </div>
    </div>

    <script>
        function toggleSelectAll(repoIndex) {
            const checkboxes = document.querySelectorAll(`.os-checkbox-${repoIndex}`);
            const selectAll = document.getElementById(`select_all_${repoIndex}`).checked;
            checkboxes.forEach(checkbox => checkbox.checked = selectAll);
        }
    </script>
@endsection
