@extends('layouts.app')

@section('title', __('messages.edit_template_os'))
@section('header', __('messages.edit_template_os'))
@section('breadcrumb', __('messages.edit_template_os'))

@section('content')
    <div class="card">
        <div class="card-body">
            <form action="{{ route('template_os.update', $templateOs->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="form-group">
                    <label for="name">{{ __('messages.name') }}</label>
                    <input type="text" name="name" class="form-control" value="{{ $templateOs->name }}" required>
                </div>
                <div class="form-group">
                    <label for="cpu_min">{{ __('messages.cpu_min') }}</label>
                    <input type="number" name="cpu_min" class="form-control" value="{{ $templateOs->cpu_min }}" required>
                </div>
                <div class="form-group">
                    <label for="ram_min">{{ __('messages.ram_min') }}</label>
                    <input type="number" name="ram_min" class="form-control" value="{{ $templateOs->ram_min }}" required>
                </div>
                <div class="form-group">
                    <label for="disk_min">{{ __('messages.disk_min') }}</label>
                    <input type="number" name="disk_min" class="form-control" value="{{ $templateOs->disk_min }}" required>
                </div>
                <div class="form-group">
                    <label for="template_path">{{ __('messages.template_path') }}</label>
                    <input type="text" name="template_path" class="form-control" value="{{ $templateOs->template_path }}" required>
                </div>

                <button type="submit" class="btn btn-primary">{{ __('messages.save') }}</button>
            </form>
        </div>
    </div>
@endsection
