@extends('layouts.app')

@section('title', __('messages.manage_ip_list'))
@section('header', __('messages.manage_ip_list'))
@section('breadcrumb', __('messages.subnet') . ": " . $subnet->subnet)

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">{{ __('messages.ip_list') }}</h3>
        </div>
        <div class="card-body">
            <table class="table table-bordered table-sm">
                <thead>
                <tr>
                    <th>{{ __('messages.ip_address') }}</th>
                    <th>{{ __('messages.status') }}</th>
                    <th>{{ __('messages.comment') }}</th>
                    <th>{{ __('messages.actions') }}</th>
                </tr>
                </thead>
                <tbody>
                @foreach($ipAddresses as $ip)
                    <tr>
                        <td>{{ $ip->ip_address }}</td>
                        <td>{{ $ip->status }}</td>
                        <td>{{ $ip->comment }}</td>
                        <td class="text-center">
                            @if($ip->status === 'available')
                                <form action="{{ route('ip.reserve', $ip->id) }}" method="POST">
                                    @csrf
                                    <button type="submit" class="btn btn-sm btn-warning">{{ __('Reserve') }}</button>
                                </form>
                            @elseif($ip->status === 'reserved')
                                <form action="{{ route('ip.release', $ip->id) }}" method="POST">
                                    @csrf
                                    <button type="submit" class="btn btn-sm btn-success">{{ __('Release') }}</button>
                                </form>
                            @endif
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
