@extends('layouts.app')

@section('title', __('messages.subnets_management'))
@section('header', __('messages.subnets_management'))
@section('breadcrumb', __('messages.subnets'))

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">{{ __('messages.subnets_list') }}</h3>
            <a href="{{ route('subnets.create') }}" class="btn btn-primary float-right">{{ __('messages.add_subnet') }}</a>
        </div>
        <div class="card-body">
            <table class="table table-bordered table-sm">
                <thead>
                <tr>
                    <th>ID</th>
                    <th>{{ __('messages.subnet') }}</th>
                    <th>{{ __('messages.subnet_type') }}</th>
                    <th>{{ __('messages.total_ips') }}</th>
                    <th>{{ __('messages.available_ips') }}</th>
                    <th>{{ __('messages.actions') }}</th>
                </tr>
                </thead>
                <tbody>
                @foreach($subnets as $subnet)
                    <tr>
                        <td>{{ $subnet->id }}</td>
                        <td>{{ $subnet->subnet }}</td>
                        <td>{{ $subnet->type }}</td>
                        <td>{{ $subnet->total_ips }}</td>
                        <td>{{ $subnet->countAvailableIps() }}</td>
                        <td class="text-center">
                            <!-- Ссылка на страницу с IP-адресами -->
                            <a href="{{ route('subnets.show_ips', $subnet->id) }}" class="btn btn-sm btn-primary">{{ __('View IPs') }}</a>
                            <!-- Кнопка для редактирования самой подсети -->
                            <a href="{{ route('subnets.edit', $subnet->id) }}" class="btn btn-sm btn-warning">{{ __('Edit Subnet') }}</a>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
