@extends('layouts.app')

@section('title', __('messages.edit_subnet'))
@section('header', __('messages.edit_subnet'))
@section('breadcrumb', __('messages.edit_subnet'))

@section('content')
    <div class="card">
        <div class="card-body">
            <form action="{{ route('subnets.update', $subnet->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="form-group">
                    <label for="subnet">{{ __('messages.subnet') }}</label>
                    <input type="text" name="subnet" class="form-control" value="{{ $subnet->subnet }}" required>
                </div>
                <div class="form-group">
                    <label for="type">{{ __('messages.subnet_type') }}</label>
                    <select name="type" class="form-control" required>
                        <option value="ipv4" {{ $subnet->type == 'ipv4' ? 'selected' : '' }}>IPv4</option>
                        <option value="ipv6" {{ $subnet->type == 'ipv6' ? 'selected' : '' }}>IPv6</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="is_ip_list">{{ __('messages.is_ip_list') }}</label>
                    <input type="checkbox" name="is_ip_list" id="is_ip_list" value="1" {{ old('is_ip_list', $subnet->is_ip_list) ? 'checked' : '' }}>
                    <label for="is_ip_list">{{ __('messages.ip_list_checkbox') }}</label>
                </div>
                <div class="form-group">
                    <label for="reserved_ips">{{ __('messages.reserve_ips') }}</label>
                    <textarea name="reserved_ips" class="form-control" placeholder="{{ __('messages.enter_reserved_ips') }}">{{ $ipAddresses->where('status', 'reserved')->pluck('ip_address')->implode(', ') }}</textarea>
                </div>
                <button type="submit" class="btn btn-success">{{ __('messages.update_subnet') }}</button>
            </form>
        </div>
    </div>
@endsection
