@extends('layouts.app')

@section('title', __('messages.add_subnet'))
@section('header', __('messages.add_subnet'))
@section('breadcrumb', __('messages.add_subnet'))

@section('content')
    <div class="card">
        <div class="card-body">
            <form action="{{ route('subnets.store') }}" method="POST">
                @csrf
                <div class="form-group">
                    <label for="subnet">{{ __('messages.subnet') }}</label>
                    <input type="text" name="subnet" class="form-control" required placeholder="Например: 192.168.1.0/24">
                </div>
                <div class="form-group">
                    <label for="type">{{ __('messages.type') }}</label>
                    <select name="type" class="form-control" required>
                        <option value="ipv4">{{ __('messages.subnet_ipv4') }}</option>
                        <option value="ipv6">{{ __('messages.subnet_ipv6') }}</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="is_ip_list">{{ __('messages.is_ip_list') }}</label>
                    <input type="checkbox" name="is_ip_list" id="is_ip_list" value="1" {{ old('is_ip_list') ? 'checked' : '' }}>
                    <label for="is_ip_list">{{ __('messages.ip_list_checkbox') }}</label>
                </div>
                <button type="submit" class="btn btn-success">{{ __('messages.add_subnet') }}</button>
            </form>
        </div>
    </div>
@endsection
