@extends('layouts.app')

@section('title', 'Settings Management')

@section('content')
    <div class="card">
        <div class="card-body">

            <!-- Проверка обновлений -->
            <form action="{{ route('check_update') }}" method="POST">
                @csrf
                <button type="submit" class="btn btn-info btn-sm mb-3">Проверить обновления</button> | <label>Текущая версия {{env("APP_VERSION")}}</label>
            </form>


            @if (session('update_available'))
                <form action="{{ route('update_panel') }}" method="POST">
                    @csrf
                    <button type="submit" class="btn btn-warning">Обновить панель</button>
                </form>
            @endif

            <hr>

            <a href="{{ route('settings.create') }}" class="btn btn-primary mb-3">Добавить настройки</a>
            <form action="{{ route('settings.update') }}" method="POST">
                @csrf

                <h4>Настройки</h4>
                @foreach ($settings as $setting)
                    <div class="form-group">
                        <label for="setting-{{ $setting->key }}">{{ ucfirst(str_replace('_', ' ', $setting->key)) }}</label>
                        <input type="text" name="settings[{{ $setting->key }}]" class="form-control" value="{{ $setting->value }}">
                    </div>
                @endforeach

                <h4>Настройки хранилища</h4>
                @foreach ($pools as $pool)
                    <div class="form-group">
                        <label for="pool-{{ $pool->id }}-name">Название пула</label>
                        <input type="text" name="pool[{{ $pool->id }}][name]" class="form-control" value="{{ $pool->name }}">
                    </div>

                    <div class="form-group">
                        <label for="pool-{{ $pool->id }}-path">Путь для пула</label>
                        <input type="text" name="pool[{{ $pool->id }}][path]" class="form-control" value="{{ $pool->path }}">
                    </div>

                    <div class="form-group">
                        <label for="pool-{{ $pool->id }}-type">Тип</label>
                        <select name="pool[{{ $pool->id }}][type]" class="form-control">
                            <option value="file_system" {{ $pool->type == 'file_system' ? 'selected' : '' }}>File System</option>
                            <option value="lvm" {{ $pool->type == 'lvm' ? 'selected' : '' }}>LVM</option>
                            <option value="net_lvm" {{ $pool->type == 'net_lvm' ? 'selected' : '' }}>Net LVM</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="pool-{{ $pool->id }}-format_disk">Формат</label>
                        <select name="pool[{{ $pool->id }}][format_disk]" class="form-control">
                            <option value="qcow2" {{ $pool->format_disk == 'qcow2' ? 'selected' : '' }}>QCOW2</option>
                            <option value="raw" {{ $pool->format_disk == 'raw' ? 'selected' : '' }}>RAW</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="pool-{{ $pool->id }}-reserve">Резерв (в %)</label>
                        <input type="text" name="pool[{{ $pool->id }}][reserve]" class="form-control" value="{{ $pool->reserve }}">
                    </div>

                    <div class="form-group">
                        <label for="pool-{{ $pool->id }}-cache_disk">Кэшировать диск</label>
                        <select name="pool[{{ $pool->id }}][cache_disk]" class="form-control">
                            <option value="writethrough" {{ $pool->cache_disk == 'writethrough' ? 'selected' : '' }}>Writethrough</option>
                            <option value="none" {{ $pool->cache_disk == 'none' ? 'selected' : '' }}>None</option>
                        </select>
                    </div>
                @endforeach

                <button type="submit" class="btn btn-success">Сохранить</button>
            </form>
        </div>
    </div>

    <!-- Управление репозиториями ОС -->
    <div class="card mt-4">
        <div class="card-body">
            <h4>Управление репозиториями ОС</h4>
            <form action="{{ route('repository.store') }}" method="POST" class="mb-3">
                @csrf
                <div class="form-group">
                    <label for="repository-url">Добавить репозиторий ОС</label>
                    <input type="text" name="url" class="form-control" placeholder="URL к info.json" required>
                </div>
                <button type="submit" class="btn btn-primary">Добавить</button>
            </form>

            <h5>Список репозиториев</h5>
            <table class="table">
                <thead>
                <tr>
                    <th>URL</th>
                    <th>Описание</th>
                    <th>Действия</th>
                </tr>
                </thead>
                <tbody>
                @foreach ($repositories as $repository)
                    <tr>
                        <td>{{ $repository->url }}</td>
                        <td>{{ $repository->description }}</td>
                        <td>
                            <form action="{{ route('repository.destroy', $repository->id) }}" method="POST" onsubmit="return confirm('Вы уверены, что хотите удалить этот репозиторий?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger">Удалить</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
