@extends('layouts.app')

@section('title', 'Активные сессии')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Активные сессии пользователей</h3>
        </div>
        <div class="card-body">
            <table class="table table-bordered table-sm">
                <thead>
                <tr>
                    <th>ID сессии</th>
                    <th>Пользователь</th>
                    <th>Email</th>
                    <th>IP адрес</th>
                    <th>Последняя активность</th>
                    <th>Действия</th>
                </tr>
                </thead>
                <tbody>
                @foreach($sessions as $session)
                    <tr>
                        <td>{{ $session->id }}</td>
                        <td>{{ $session->name }}</td>
                        <td>{{ $session->email }}</td>
                        <td>{{ $session->ip_address }}</td>
                        <td>{{ \Carbon\Carbon::createFromTimestamp($session->last_activity)->diffForHumans() }}</td>
                        <td>
                            <form action="{{ route('sessions.destroy', $session->id) }}" method="POST">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Вы уверены, что хотите завершить эту сессию?');">
                                    Завершить сессию
                                </button>
                            </form>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
