@extends('layouts.app')

@section('title', 'Add Role')
@section('header', 'Add Role')
@section('breadcrumb', 'Add Role')

@section('content')
    <div class="card">
        <div class="card-body">
            <form action="{{ route('roles.store') }}" method="POST">
                @csrf
                <div class="form-group">
                    <label for="name">Role Name</label>
                    <input type="text" name="name" class="form-control" required>
                </div>
                <div class="form-group">
                    <label for="permissions">Permissions</label>
                    <select name="permissions[]" class="form-control" multiple>
                        @foreach($permissions as $permission)
                            <option value="{{ $permission->id }}">{{ $permission->name }}</option>
                        @endforeach
                    </select>
                </div>
                <button type="submit" class="btn btn-success">Create Role</button>
            </form>
        </div>
    </div>
@endsection
