@extends('layouts.app')

@section('title', 'Job Monitoring')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Jobs Monitoring</h3>
        </div>
        <div class="card-body">
            <table class="table table-bordered">
                <thead>
                <tr>
                    <th>ID</th>
                    <th>Job Name</th>
                    <th>Status</th>
                    <th>Started At</th>
                    <th>Finished At</th>
                    <th>Failed At</th>
                    <th>Message</th>
                </tr>
                </thead>
                <tbody>
                @foreach($jobs as $job)
                    <tr>
                        <td>{{ $job->id }}</td>
                        <td>{{ $job->job_name }}</td>
                        <td>{{ $job->status }}</td>
                        <td>{{ $job->started_at ? $job->started_at->format('Y-m-d H:i:s') : 'N/A' }}</td>
                        <td>{{ $job->finished_at ? $job->finished_at->format('Y-m-d H:i:s') : 'N/A' }}</td>
                        <td>{{ $job->failed_at ? $job->failed_at->format('Y-m-d H:i:s') : 'N/A' }}</td>
                        <td>{{ $job->exception ?? 'No errors' }}</td>
                    </tr>
                @endforeach
                </tbody>
            </table>
            {{ $jobs->links() }}
        </div>
    </div>
@endsection
