@extends('layouts.auth')

@section('title', 'Установка системы')

@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">Установка системы</div>

                    <div class="card-body">
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        <form method="POST" action="{{ route('install.perform') }}">
                            @csrf

                            <div class="form-group">
                                <label for="admin_name">Имя администратора</label>
                                <input type="text" name="admin_name" class="form-control" value="{{ old('admin_name') }}" required autofocus>
                            </div>

                            <div class="form-group">
                                <label for="admin_email">Email администратора</label>
                                <input type="email" name="admin_email" class="form-control" value="{{ old('admin_email') }}" required>
                            </div>

                            <div class="form-group">
                                <label for="admin_password">Пароль администратора</label>
                                <input type="password" name="admin_password" class="form-control" required>
                            </div>

                            <div class="form-group">
                                <label for="admin_password_confirmation">Подтверждение пароля</label>
                                <input type="password" name="admin_password_confirmation" class="form-control" required>
                            </div>

                            <button type="submit" class="btn btn-primary">Установить</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
