@extends('layouts.app')

@section('title', __('messages.host_nodes_management'))
@section('header', __('messages.host_nodes_management'))
@section('breadcrumb', __('messages.host_nodes_management'))

@section('content')
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h3 class="card-title">{{ __('messages.host_nodes_list') }}</h3>
            <a href="{{ route('host_nodes.create') }}" class="btn btn-success btn-sm ml-auto">
                <i class="fas fa-plus"></i>
            </a>
        </div>
        <div class="card-body">
            <!-- Форма поиска -->
            <form action="{{ route('host_nodes.index') }}" method="GET" class="mb-3">
                <div class="input-group">
                    <input type="text" name="search" class="form-control" placeholder="{{ __('messages.search_placeholder') }}" value="{{ request('search') }}">
                    <div class="input-group-append">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-search"></i> {{ __('messages.search') }}
                        </button>
                    </div>
                </div>
            </form>

            <!-- Таблица узлов -->
            <table class="table table-hover table-bordered">
                <thead class="thead-light">
                <tr>
                    <th>{{ __('messages.id') }}</th>
                    <th>{{ __('messages.name') }}</th>
                    <th>{{ __('messages.ip_address') }}</th>
                    <th class="text-center">{{ __('messages.status') }}</th>
                    <th class="text-center">{{ __('messages.actions') }}</th>
                </tr>
                </thead>
                <tbody>
                @foreach($hostNodes as $hostNode)
                    <tr>
                        <td>{{ $hostNode->id }}</td>
                        <td>{{ $hostNode->name }}</td>
                        <td>{{ $hostNode->ip_address }}</td>
                        <td class="text-center">
                            @switch($hostNode->status)
                                @case('active')
                                    <span class="badge badge-success">
                                        <i class="fas fa-check-circle"></i> {{ __('messages.active') }}
                                    </span>
                                    @break
                                @case('inactive')
                                    <span class="badge badge-warning">
                                        <i class="fas fa-times-circle"></i> {{ __('messages.inactive') }}
                                    </span>
                                    @break
                                @case('error')
                                    <span class="badge badge-danger">
                                        <i class="fas fa-exclamation-triangle"></i> {{ __('messages.error') }}
                                    </span>
                                    @break
                                @case('installing')
                                    <span class="badge badge-info">
                                        <i class="fas fa-cogs"></i> {{ __('messages.installing') }}
                                    </span>
                                    @break
                            @endswitch
                        </td>
                        <td class="text-center">
                            <a href="{{ route('host_nodes.edit', $hostNode->id) }}" class="btn btn-sm btn-warning mr-1">
                                <i class="fas fa-edit"></i> {{ __('messages.edit') }}
                            </a>
                            <form action="{{ route('host_nodes.destroy', $hostNode->id) }}" method="POST" style="display:inline;" onsubmit="return confirm('{{ __('messages.delete_confirmation') }}');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger">
                                    <i class="fas fa-trash-alt"></i> {{ __('messages.delete') }}
                                </button>
                            </form>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
