@extends('layouts.app')

@section('title', 'Edit Host Node')
@section('header', 'Edit Host Node')
@section('breadcrumb', 'Edit Host Node')

@section('content')
    <div class="card">
        <div class="card-body">
            <form action="{{ route('host_nodes.update', $hostNode->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="form-group">
                    <label for="name">Name</label>
                    <input type="text" name="name" class="form-control" value="{{ $hostNode->name }}" required>
                </div>
                <div class="form-group">
                    <label for="ip_address">IP Address</label>
                    <input type="text" name="ip_address" class="form-control" value="{{ $hostNode->ip_address }}" required>
                </div>
                <div class="form-group">
                    <label for="ssh_username">SSH Username</label>
                    <input type="text" name="ssh_username" class="form-control" value="{{ $hostNode->ssh_username }}" required>
                </div>
                <div class="form-group">
                    <label for="ssh_password">SSH Password</label>
                    <input type="password" name="ssh_password" class="form-control">
                </div>
                <div class="form-group">
                    <label for="ssh_port">SSH Port</label>
                    <input type="number" name="ssh_port" class="form-control" placeholder="22">
                </div>
                <div class="form-group">
                    <label for="agent_port">SSH Port</label>
                    <input type="number" name="agent_port" class="form-control" placeholder="1515">
                </div>
                <div class="form-group">
                    <label for="description">Description</label>
                    <textarea name="description" class="form-control">{{ $hostNode->description }}</textarea>
                </div>
                <button type="submit" class="btn btn-success">Update Host Node</button>
            </form>
        </div>
    </div>
@endsection
