@extends('layouts.app')

@section('title', __('messages.add_host_node'))
@section('header', __('messages.add_host_node'))
@section('breadcrumb', __('messages.add_host_node'))

@section('content')
    <div class="card">
        <div class="card-body">
            <form action="{{ route('host_nodes.store') }}" method="POST">
                @csrf
                <div class="form-group">
                    <label for="name">{{ __('messages.name') }}</label>
                    <input type="text" name="name" class="form-control" required>
                </div>
                <div class="form-group">
                    <label for="ip_address">{{ __('messages.ip_address') }}</label>
                    <input type="text" name="ip_address" class="form-control" required>
                </div>
                <div class="form-group">
                    <label for="ssh_username">{{ __('messages.ssh_username') }}</label>
                    <input type="text" name="ssh_username" class="form-control" required>
                </div>
                <div class="form-group">
                    <label for="ssh_password">{{ __('messages.ssh_password') }}</label>
                    <input type="password" name="ssh_password" class="form-control">
                </div>
                <div class="form-group">
                    <label for="ssh_port">{{ __('messages.ssh_port') }}</label>
                    <input type="number" name="ssh_port" class="form-control" placeholder="22" value="22">
                </div>
                <div class="form-group">
                    <label for="agent_port">{{ __('messages.agent_port') }}</label>
                    <input type="number" name="agent_port" class="form-control" placeholder="1515" value="1515">
                </div>

                <!-- Дополнительная форма для LVM -->
                @if($pool && $pool->type === 'lvm')
                    <div class="form-group">
                        <label for="lvm_disk">{{ __('messages.lvm_disk') }}</label>
                        <input type="text" name="lvm_disk" class="form-control" placeholder="/dev/sdX">
                    </div>
                @endif

                <div class="form-group">
                    <label for="description">{{ __('messages.description') }}</label>
                    <textarea name="description" class="form-control"></textarea>
                </div>

                <button type="submit" class="btn btn-success">{{ __('messages.add_host_node') }}</button>
            </form>
        </div>
    </div>
@endsection
