<!-- resources/views/dashboard/index.blade.php -->
@extends('layouts.app')

@section('title', __('messages.dashboard'))
@section('header', __('messages.dashboard'))
@section('breadcrumb', __('messages.dashboard'))

@section('content')
    <div class="container-fluid">
        <!-- Info boxes -->
        <div class="row">
            <!-- Cluster Nodes Count -->
            <div class="col-12 col-sm-6 col-md-3">
                <div class="info-box">
                    <span class="info-box-icon bg-info elevation-1"><i class="fas fa-server"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">{{ __('messages.cluster_nodes') }}</span>
                        <span class="info-box-number">
                            {{ rand(5, 20) }}
                        </span>
                    </div>
                </div>
            </div>

            <!-- Virtual Machines Count -->
            <div class="col-12 col-sm-6 col-md-3">
                <div class="info-box">
                    <span class="info-box-icon bg-success elevation-1"><i class="fas fa-hdd"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">{{ __('messages.virtual_machines') }}</span>
                        <span class="info-box-number">
                            {{ rand(50, 200) }}
                        </span>
                    </div>
                </div>
            </div>

            <!-- Users Count -->
            <div class="col-12 col-sm-6 col-md-3">
                <div class="info-box">
                    <span class="info-box-icon bg-warning elevation-1"><i class="fas fa-users"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">{{ __('messages.users') }}</span>
                        <span class="info-box-number">
                            {{ rand(10, 100) }}
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Top 10 Virtual Machines by Load -->
        <div class="row">
            <div class="col-12 col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">{{ __('messages.top_10_virtual_machines') }}</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered table-hover">
                            <thead>
                            <tr>
                                <th>{{ __('messages.name') }}</th>
                                <th>{{ __('messages.cpu_usage') }}</th>
                                <th>{{ __('messages.ram_usage') }}</th>
                            </tr>
                            </thead>
                            <tbody>
                            @for ($i = 0; $i < 10; $i++)
                                <tr>
                                    <td>VM-{{ $i + 1 }}</td>
                                    <td>{{ rand(10, 100) }}%</td>
                                    <td>{{ rand(10, 100) }}%</td>
                                </tr>
                            @endfor
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Top 10 Cluster Nodes by Load -->
            <div class="col-12 col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">{{ __('messages.top_10_nodes') }}</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered table-hover">
                            <thead>
                            <tr>
                                <th>{{ __('messages.name') }}</th>
                                <th>{{ __('messages.cpu_usage') }}</th>
                                <th>{{ __('messages.ram_usage') }}</th>
                            </tr>
                            </thead>
                            <tbody>
                            @for ($i = 0; $i < 10; $i++)
                                <tr>
                                    <td>Node-{{ $i + 1 }}</td>
                                    <td>{{ rand(10, 100) }}%</td>
                                    <td>{{ rand(10, 100) }}%</td>
                                </tr>
                            @endfor
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
