<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Role;
use App\Models\Permission;

class RolePermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Назначение всех прав роли "Админ"
        $adminRole = Role::where('name', 'admin')->first();
        $allPermissions = Permission::all();

        if ($adminRole) {
            $adminRole->permissions()->sync($allPermissions->pluck('id')->toArray());
        }

        // Назначение роли "Пользователь" без прав доступа
        $userRole = Role::where('name', 'user')->first();

        if ($userRole) {
            $userRole->permissions()->sync([]); // Пустой массив, чтобы пользователь не имел прав по умолчанию
        }
    }
}
