<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Permission;

class PermissionsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $permissions = [
            'manage-users',
            'view-nodes',
            'manage-roles',
            'manage-permissions',
            'manage-host-nodes',
            'view_host_nodes',
            'create_host_nodes',
            'edit_host_nodes',
            'delete_host_nodes',
            'view_virtual_machines',
            'create_virtual_machines',
            'edit_virtual_machines',
            'delete_virtual_machines',
            'manage-template-os',
            'view_template_os',
            'download_template_os',
            'reinstall_template_os',
            'delete_template_os',
            'view-sessions',
            'delete-sessions'
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission]);
        }
    }
}
