<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('virtual_machine_templates', function (Blueprint $table) {
            $table->id();
            $table->string('name')->unique(); // Название шаблона
            $table->integer('cpu'); // Количество CPU
            $table->integer('memory'); // Память в МБ
            $table->integer('disk_size'); // Размер диска в ГБ
            $table->integer('snapshot_limit')->nullable(); // Количество снимков
            $table->string('network_bridge')->default('br0'); // Сетевой мост
            $table->enum('network_model', ['virtio', 'i82551', 'i82557b', 'i82559er', 'ne2k_pci', 'pcnet', 'rtl8139'])->default('virtio'); // Модель сетевой карты
            $table->integer('cpu_weight')->default(1024); // Вес CPU
            $table->integer('io_weight')->default(500); // Вес I/O
            $table->string('cpu_emulation')->default('host'); // Режим эмуляции процессора
            $table->integer('network_in')->default(1000); // Входящий трафик
            $table->integer('network_out')->default(1000); // Исходящий трафик
            $table->foreignId('storage_pool_id')->constrained('pools')->onDelete('cascade'); // Шаблон хранилища
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('virtual_machine_templates');
    }
};
