<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('subnets', function (Blueprint $table) {
            $table->id();
            $table->string('subnet');
            $table->enum('type', ['ipv4', 'ipv6']);
            $table->integer('total_ips');
            $table->boolean('is_ip_list')->default(false); // По умолчанию это подсеть
            $table->timestamps();
        });

        Schema::create('ip_addresses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('subnet_id')->constrained('subnets')->onDelete('cascade');
            $table->foreignId('virtual_machine_id')->nullable()->constrained('virtual_machines')->onDelete('set null');
            $table->string('ip_address')->unique();
            $table->enum('type', ['ipv4', 'ipv6']);
            $table->enum('status', ['assigned', 'available', 'reserved'])->default('available');
            $table->string('comment')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ip_addresses');
        Schema::dropIfExists('subnets');
    }
};
