<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pools', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('path');
            $table->enum('type', ['file_system','lvm','net_lvm'])->default('file_system');
            $table->enum('format_disk', ['qcow2','raw'])->default('qcow2');
            $table->string('reserve')->default(0);
            $table->enum('cache_disk', ['writethrough', 'none'])->default('writethrough');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pools');
    }
};
