<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('disks', function (Blueprint $table) {
            $table->id();
            $table->foreignId('virtual_machine_id')->constrained()->onDelete('cascade'); // Привязка к ВМ
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('host_node_id')->constrained(); // Привязка к хост-ноде
            $table->integer('size'); // Размер диска в GiB
            $table->string('path'); // Путь к диску
            $table->enum('type', ['qcow2', 'raw']); // Формат диска
            $table->enum('status', ['creating', 'created', 'error'])->default('creating'); // Статус создания
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('disks');
    }
};
