<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('node_stats', function (Blueprint $table) {
            $table->id();
            $table->foreignId('node_id')->constrained('host_nodes')->onDelete('cascade');
            $table->float('cpu_usage')->nullable();
            $table->float('memory_usage')->nullable();
            $table->integer('incoming_traffic')->nullable(); // Входящий трафик в МБ
            $table->integer('outgoing_traffic')->nullable(); // Исходящий трафик в МБ
            $table->timestamp('collected_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('node_stats');
    }
};
