<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vm_stats', function (Blueprint $table) {
            $table->id();
            $table->foreignId('vm_id')->constrained('virtual_machines')->onDelete('cascade');
            $table->float('cpu_usage')->nullable();
            $table->float('memory_usage')->nullable();
            $table->bigInteger('disk_read_bytes')->nullable();
            $table->bigInteger('disk_write_bytes')->nullable();
            $table->bigInteger('network_in_bytes')->nullable();
            $table->bigInteger('network_out_bytes')->nullable();
            $table->timestamp('collected_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vm_stats');
    }
};
