<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('virtual_machines', function (Blueprint $table) {
            $table->id();
            $table->foreignId('node_id')->constrained('host_nodes')->onDelete('cascade');
            $table->string('vm_name')->unique();
            $table->text('description')->nullable();
            $table->enum('status', ['running', 'stopped', 'suspended', 'migrating', 'failed' , 'blocked'])->default('stopped');
            $table->integer('cpu');
            $table->integer('memory');
            $table->integer('disk_size');
            $table->integer('migration_progress')->nullable(); // Поле для отслеживания прогресса миграции
            $table->string('ssh_username')->nullable(); // Логин для SSH
            $table->string('ssh_password')->nullable(); // Пароль для SSH
            $table->string('rdp_username')->nullable(); // Логин для RDP
            $table->string('rdp_password')->nullable(); // Пароль для RDP
            $table->string('domain')->nullable(); // Домен виртуальной машины
            $table->string('vnc_password')->nullable(); // Пароль для VNC
            $table->string('cpu_emulation')->default('host'); // Режим эмуляции процессора
            $table->integer('network_in')->nullable(); // Входящий трафик
            $table->integer('network_out')->nullable(); // Исходящий трафик
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('virtual_machines');
    }
};
